/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.ClientContextImpl;
import com.launchdarkly.sdk.android.ConnectionInformation;
import com.launchdarkly.sdk.android.ConnectionInformationState;
import com.launchdarkly.sdk.android.ContextDataManager;
import com.launchdarkly.sdk.android.DataModel;
import com.launchdarkly.sdk.android.Debounce;
import com.launchdarkly.sdk.android.EnvironmentData;
import com.launchdarkly.sdk.android.FeatureFetcher;
import com.launchdarkly.sdk.android.LDConfig;
import com.launchdarkly.sdk.android.LDFailure;
import com.launchdarkly.sdk.android.LDStatusListener;
import com.launchdarkly.sdk.android.LDUtil;
import com.launchdarkly.sdk.android.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.android.PlatformState;
import com.launchdarkly.sdk.android.TaskExecutor;
import com.launchdarkly.sdk.android.subsystems.Callback;
import com.launchdarkly.sdk.android.subsystems.ClientContext;
import com.launchdarkly.sdk.android.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.android.subsystems.DataSource;
import com.launchdarkly.sdk.android.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.android.subsystems.EventProcessor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class ConnectivityManager {
    private static final long MAX_RETRY_TIME_MS = 60000L;
    private static final long RETRY_TIME_MS = 1000L;
    private final ClientContext baseClientContext;
    private final PlatformState platformState;
    private final ComponentConfigurer<DataSource> dataSourceFactory;
    private final DataSourceUpdateSink dataSourceUpdateSink;
    private final ConnectionInformationState connectionInformation;
    private final PersistentDataStoreWrapper.PerEnvironmentData environmentStore;
    private final ContextDataManager contextDataManager;
    private final EventProcessor eventProcessor;
    private final PlatformState.ForegroundChangeListener foregroundListener;
    private final PlatformState.ConnectivityChangeListener connectivityChangeListener;
    private final TaskExecutor taskExecutor;
    private final boolean backgroundUpdatingDisabled;
    private final List<WeakReference<LDStatusListener>> statusListeners = new ArrayList<WeakReference<LDStatusListener>>();
    private final Debounce pollDebouncer = new Debounce();
    private final AtomicBoolean forcedOffline = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicReference<DataSource> currentDataSource = new AtomicReference();
    private final AtomicReference<LDContext> currentEvaluationContext = new AtomicReference();
    private final AtomicReference<Boolean> previouslyInBackground = new AtomicReference();
    private final LDLogger logger;
    private volatile boolean initialized = false;

    ConnectivityManager(@NonNull ClientContext clientContext, @NonNull ComponentConfigurer<DataSource> dataSourceFactory, @NonNull EventProcessor eventProcessor, @NonNull ContextDataManager contextDataManager, @NonNull PersistentDataStoreWrapper.PerEnvironmentData environmentStore) {
        this.baseClientContext = clientContext;
        this.dataSourceFactory = dataSourceFactory;
        this.dataSourceUpdateSink = new DataSourceUpdateSinkImpl();
        this.platformState = ClientContextImpl.get(clientContext).getPlatformState();
        this.eventProcessor = eventProcessor;
        this.contextDataManager = contextDataManager;
        this.environmentStore = environmentStore;
        this.taskExecutor = ClientContextImpl.get(clientContext).getTaskExecutor();
        this.logger = clientContext.getBaseLogger();
        this.currentEvaluationContext.set(clientContext.getEvaluationContext());
        this.forcedOffline.set(clientContext.isSetOffline());
        LDConfig ldConfig = clientContext.getConfig();
        this.connectionInformation = new ConnectionInformationState();
        this.readStoredConnectionState();
        this.backgroundUpdatingDisabled = ldConfig.isDisableBackgroundPolling();
        this.connectivityChangeListener = networkAvailable -> this.updateDataSource(false, LDUtil.noOpCallback());
        this.platformState.addConnectivityChangeListener(this.connectivityChangeListener);
        this.foregroundListener = foreground -> {
            DataSource dataSource = this.currentDataSource.get();
            if (dataSource == null || dataSource.needsRefresh(!foreground, this.currentEvaluationContext.get())) {
                this.updateDataSource(true, LDUtil.noOpCallback());
            }
        };
        this.platformState.addForegroundChangeListener(this.foregroundListener);
    }

    void setEvaluationContext(@NonNull LDContext newContext, @NonNull Callback<Void> onCompletion) {
        DataSource dataSource = this.currentDataSource.get();
        LDContext oldContext = this.currentEvaluationContext.getAndSet(newContext);
        if (oldContext == newContext || oldContext.equals((Object)newContext)) {
            onCompletion.onSuccess(null);
        } else if (dataSource == null || dataSource.needsRefresh(!this.platformState.isForeground(), newContext)) {
            this.updateDataSource(true, onCompletion);
        } else {
            onCompletion.onSuccess(null);
        }
    }

    private boolean updateDataSource(boolean mustReinitializeDataSource, final @NonNull Callback<Void> onCompletion) {
        DataSource oldDataSource;
        if (!this.started.get()) {
            return false;
        }
        boolean forceOffline = this.forcedOffline.get();
        boolean networkEnabled = this.platformState.isNetworkAvailable();
        boolean inBackground = !this.platformState.isForeground();
        LDContext evaluationContext = this.currentEvaluationContext.get();
        this.eventProcessor.setOffline(forceOffline || !networkEnabled);
        this.eventProcessor.setInBackground(inBackground);
        boolean shouldStopExistingDataSource = true;
        boolean shouldStartDataSourceIfStopped = false;
        if (forceOffline) {
            this.logger.debug((Object)"Initialized in offline mode");
            this.initialized = true;
            this.dataSourceUpdateSink.setStatus(ConnectionInformation.ConnectionMode.SET_OFFLINE, null);
        } else if (!networkEnabled) {
            this.dataSourceUpdateSink.setStatus(ConnectionInformation.ConnectionMode.OFFLINE, null);
        } else if (inBackground && this.backgroundUpdatingDisabled) {
            this.dataSourceUpdateSink.setStatus(ConnectionInformation.ConnectionMode.BACKGROUND_DISABLED, null);
        } else {
            shouldStopExistingDataSource = mustReinitializeDataSource;
            shouldStartDataSourceIfStopped = true;
        }
        if (shouldStopExistingDataSource && (oldDataSource = (DataSource)this.currentDataSource.getAndSet(null)) != null) {
            this.logger.debug((Object)"Stopping current data source");
            oldDataSource.stop(LDUtil.noOpCallback());
        }
        if (!shouldStartDataSourceIfStopped || this.currentDataSource.get() != null) {
            onCompletion.onSuccess(null);
            return false;
        }
        this.logger.debug("Creating data source (background={})", (Object)inBackground);
        ClientContextImpl clientContext = ClientContextImpl.forDataSource(this.baseClientContext, this.dataSourceUpdateSink, evaluationContext, inBackground, this.previouslyInBackground.get());
        DataSource dataSource = this.dataSourceFactory.build(clientContext);
        this.currentDataSource.set(dataSource);
        this.previouslyInBackground.set(inBackground);
        dataSource.start(new Callback<Boolean>(){

            @Override
            public void onSuccess(Boolean result) {
                ConnectivityManager.this.initialized = true;
                onCompletion.onSuccess(null);
            }

            @Override
            public void onError(Throwable error) {
                onCompletion.onSuccess(null);
            }
        });
        return true;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStatusListener(LDStatusListener LDStatusListener2) {
        if (LDStatusListener2 == null) {
            return;
        }
        List<WeakReference<LDStatusListener>> list = this.statusListeners;
        synchronized (list) {
            this.statusListeners.add(new WeakReference<LDStatusListener>(LDStatusListener2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterStatusListener(LDStatusListener LDStatusListener2) {
        if (LDStatusListener2 == null) {
            return;
        }
        List<WeakReference<LDStatusListener>> list = this.statusListeners;
        synchronized (list) {
            Iterator<WeakReference<LDStatusListener>> iter = this.statusListeners.iterator();
            while (iter.hasNext()) {
                LDStatusListener mListener = (LDStatusListener)iter.next().get();
                if (mListener != null && mListener != LDStatusListener2) continue;
                iter.remove();
            }
        }
    }

    private void readStoredConnectionState() {
        PersistentDataStoreWrapper.SavedConnectionInfo savedConnectionInfo = this.environmentStore.getConnectionInfo();
        Long lastSuccessTime = savedConnectionInfo.lastSuccessTime;
        Long lastFailureTime = savedConnectionInfo.lastFailureTime;
        this.connectionInformation.setLastSuccessfulConnection(lastSuccessTime == null || lastSuccessTime == 0L ? null : Long.valueOf(lastSuccessTime));
        this.connectionInformation.setLastFailedConnection(lastFailureTime == null || lastFailureTime == 0L ? null : Long.valueOf(lastFailureTime));
        this.connectionInformation.setLastFailure(savedConnectionInfo.lastFailure);
    }

    private synchronized void saveConnectionInformation() {
        PersistentDataStoreWrapper.SavedConnectionInfo savedConnectionInfo = new PersistentDataStoreWrapper.SavedConnectionInfo(this.connectionInformation.getLastSuccessfulConnection(), this.connectionInformation.getLastFailedConnection(), this.connectionInformation.getLastFailure());
        this.environmentStore.setConnectionInfo(savedConnectionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatusListeners(ConnectionInformation connectionInformation) {
        List<WeakReference<LDStatusListener>> list = this.statusListeners;
        synchronized (list) {
            Iterator<WeakReference<LDStatusListener>> iter = this.statusListeners.iterator();
            while (iter.hasNext()) {
                LDStatusListener mListener = (LDStatusListener)iter.next().get();
                if (mListener == null) {
                    iter.remove();
                    continue;
                }
                this.taskExecutor.scheduleTask(() -> mListener.onConnectionModeChanged(connectionInformation), 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListenersOnFailure(LDFailure ldFailure) {
        List<WeakReference<LDStatusListener>> list = this.statusListeners;
        synchronized (list) {
            Iterator<WeakReference<LDStatusListener>> iter = this.statusListeners.iterator();
            while (iter.hasNext()) {
                LDStatusListener mListener = (LDStatusListener)iter.next().get();
                if (mListener == null) {
                    iter.remove();
                    continue;
                }
                this.taskExecutor.scheduleTask(() -> mListener.onInternalFailure(ldFailure), 0L);
            }
        }
    }

    synchronized boolean startUp(@NonNull Callback<Void> onCompletion) {
        if (this.closed.get() || this.started.getAndSet(true)) {
            return false;
        }
        this.initialized = false;
        this.contextDataManager.initFromStoredData(this.currentEvaluationContext.get());
        return this.updateDataSource(true, onCompletion);
    }

    void shutDown() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        DataSource oldDataSource = this.currentDataSource.getAndSet(null);
        if (oldDataSource != null) {
            oldDataSource.stop(LDUtil.noOpCallback());
        }
        this.platformState.removeForegroundChangeListener(this.foregroundListener);
        this.platformState.removeConnectivityChangeListener(this.connectivityChangeListener);
    }

    void setForceOffline(boolean forceOffline) {
        boolean wasForcedOffline = this.forcedOffline.getAndSet(forceOffline);
        if (forceOffline != wasForcedOffline) {
            this.updateDataSource(false, LDUtil.noOpCallback());
        }
    }

    boolean isForcedOffline() {
        return this.forcedOffline.get();
    }

    synchronized ConnectionInformation getConnectionInformation() {
        return this.connectionInformation;
    }

    static void fetchAndSetData(FeatureFetcher fetcher, final LDContext currentContext, final DataSourceUpdateSink dataSourceUpdateSink, final Callback<Boolean> resultCallback, final LDLogger logger) {
        fetcher.fetch(currentContext, new Callback<String>(){

            @Override
            public void onSuccess(String flagsJson) {
                EnvironmentData data;
                try {
                    data = EnvironmentData.fromJson(flagsJson);
                }
                catch (Exception e) {
                    logger.debug("Received invalid JSON flag data: {}", (Object)flagsJson);
                    resultCallback.onError(new LDFailure("Invalid JSON received from flags endpoint", e, LDFailure.FailureType.INVALID_RESPONSE_BODY));
                    return;
                }
                dataSourceUpdateSink.init(data.getAll());
                resultCallback.onSuccess(true);
            }

            @Override
            public void onError(Throwable e) {
                logger.error("Error when attempting to get flag data: [{}] [{}]: {}", new Object[]{LDUtil.base64Url(currentContext), currentContext, LogValues.exceptionSummary((Throwable)e)});
                resultCallback.onError(e);
            }
        });
    }

    private class DataSourceUpdateSinkImpl
    implements DataSourceUpdateSink {
        private final AtomicReference<ConnectionInformation.ConnectionMode> connectionMode = new AtomicReference<Object>(null);
        private final AtomicReference<LDFailure> lastFailure = new AtomicReference<Object>(null);

        private DataSourceUpdateSinkImpl() {
        }

        @Override
        public void init(Map<String, DataModel.Flag> items) {
            ConnectivityManager.this.contextDataManager.initData((LDContext)ConnectivityManager.this.currentEvaluationContext.get(), EnvironmentData.usingExistingFlagsMap(items));
        }

        @Override
        public void upsert(DataModel.Flag item) {
            ConnectivityManager.this.contextDataManager.upsert(item);
        }

        @Override
        public void setStatus(ConnectionInformation.ConnectionMode newConnectionMode, Throwable error) {
            ConnectionInformation.ConnectionMode oldConnectionMode = newConnectionMode == null ? null : this.connectionMode.getAndSet(newConnectionMode);
            LDFailure failure = null;
            if (error != null) {
                failure = error instanceof LDFailure ? (LDFailure)error : new LDFailure("Unknown failure", error, LDFailure.FailureType.UNKNOWN_ERROR);
                this.lastFailure.set(failure);
            }
            boolean updated = false;
            if (newConnectionMode != null && oldConnectionMode != newConnectionMode) {
                if (failure == null && newConnectionMode.isConnectionActive()) {
                    ConnectivityManager.this.connectionInformation.setLastSuccessfulConnection(System.currentTimeMillis());
                }
                ConnectivityManager.this.connectionInformation.setConnectionMode(newConnectionMode);
                updated = true;
            }
            if (failure != null) {
                ConnectivityManager.this.connectionInformation.setLastFailedConnection(System.currentTimeMillis());
                ConnectivityManager.this.connectionInformation.setLastFailure(failure);
                updated = true;
            }
            if (updated) {
                try {
                    ConnectivityManager.this.saveConnectionInformation();
                }
                catch (Exception ex) {
                    LDUtil.logExceptionAtErrorLevel(ConnectivityManager.this.logger, ex, "Error saving connection information", new Object[0]);
                }
                ConnectivityManager.this.updateStatusListeners(ConnectivityManager.this.connectionInformation);
                if (failure != null) {
                    ConnectivityManager.this.updateListenersOnFailure(failure);
                }
            }
        }

        @Override
        public void shutDown() {
            ConnectivityManager.this.shutDown();
            this.setStatus(ConnectionInformation.ConnectionMode.SHUTDOWN, null);
        }
    }
}

