/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.ClientContextImpl;
import com.launchdarkly.sdk.android.ContextHasher;
import com.launchdarkly.sdk.android.ContextIndex;
import com.launchdarkly.sdk.android.DataModel;
import com.launchdarkly.sdk.android.EnvironmentData;
import com.launchdarkly.sdk.android.FeatureFlagChangeListener;
import com.launchdarkly.sdk.android.LDAllFlagsListener;
import com.launchdarkly.sdk.android.LDFailure;
import com.launchdarkly.sdk.android.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.android.TaskExecutor;
import com.launchdarkly.sdk.android.subsystems.Callback;
import com.launchdarkly.sdk.android.subsystems.ClientContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

final class ContextDataManager {
    static final ContextHasher HASHER = new ContextHasher();
    private final PersistentDataStoreWrapper.PerEnvironmentData environmentStore;
    private final int maxCachedContexts;
    private final TaskExecutor taskExecutor;
    private final ConcurrentHashMap<String, Set<FeatureFlagChangeListener>> listeners = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<LDAllFlagsListener> allFlagsListeners = new CopyOnWriteArrayList();
    private final LDLogger logger;
    private final Object writerLock = new Object();
    @NonNull
    private volatile LDContext currentContext;
    @NonNull
    private volatile EnvironmentData flags = new EnvironmentData();
    @NonNull
    private volatile ContextIndex index = null;
    private volatile String flagsContextId = null;

    ContextDataManager(@NonNull ClientContext clientContext, @NonNull PersistentDataStoreWrapper.PerEnvironmentData environmentStore, int maxCachedContexts) {
        this.currentContext = clientContext.getEvaluationContext();
        this.environmentStore = environmentStore;
        this.maxCachedContexts = maxCachedContexts;
        this.taskExecutor = ClientContextImpl.get(clientContext).getTaskExecutor();
        this.logger = clientContext.getBaseLogger();
    }

    @NonNull
    public LDContext getCurrentContext() {
        return this.currentContext;
    }

    public void setCurrentContext(@NonNull LDContext newContext) {
        this.currentContext = newContext;
    }

    @Nullable
    public EnvironmentData getStoredData(LDContext context) {
        return this.environmentStore.getContextData(ContextDataManager.hashedContextId(context));
    }

    public void initData(@NonNull LDContext context, @NonNull EnvironmentData newData) {
        this.logger.debug((Object)"Initializing with new flag data for this context");
        this.initDataInternal(context, newData, true);
    }

    public boolean initFromStoredData(@NonNull LDContext context) {
        EnvironmentData storedData = this.getStoredData(context);
        if (storedData == null) {
            this.logger.debug((Object)"No stored flag data is available for this context");
            return false;
        }
        this.logger.debug((Object)"Using stored flag data for this context");
        this.initDataInternal(context, storedData, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDataInternal(@NonNull LDContext context, @NonNull EnvironmentData newData, boolean writeFlagsToPersistentStore) {
        ContextIndex newIndex;
        EnvironmentData oldData;
        ArrayList<String> removedContextIds = new ArrayList<String>();
        String contextId = ContextDataManager.hashedContextId(context);
        Iterator iterator = this.writerLock;
        synchronized (iterator) {
            this.currentContext = context;
            oldData = this.flags;
            this.flags = newData;
            if (this.index == null) {
                this.index = this.environmentStore.getIndex();
            }
            this.index = newIndex = this.index.updateTimestamp(contextId, System.currentTimeMillis()).prune(this.maxCachedContexts, removedContextIds);
            this.flagsContextId = contextId;
        }
        for (String removedContextId : removedContextIds) {
            this.environmentStore.removeContextData(removedContextId);
            this.logger.debug("Removed flag data for context {} from persistent store", (Object)removedContextId);
        }
        if (writeFlagsToPersistentStore && this.maxCachedContexts != 0) {
            this.environmentStore.setContextData(contextId, newData);
            this.logger.debug("Updated flag data for context {} in persistent store", (Object)contextId);
        }
        if (this.logger.isEnabled(LDLogLevel.DEBUG)) {
            this.logger.debug("Stored context index is now: {}", (Object)newIndex.toJson());
        }
        this.environmentStore.setIndex(newIndex);
        HashSet<String> updatedFlagKeys = new HashSet<String>();
        for (DataModel.Flag newFlag : newData.values()) {
            DataModel.Flag oldFlag = oldData.getFlag(newFlag.getKey());
            if (oldFlag != null && oldFlag.getVersion() == newFlag.getVersion()) continue;
            updatedFlagKeys.add(newFlag.getKey());
        }
        for (DataModel.Flag oldFlag : oldData.values()) {
            if (newData.getFlag(oldFlag.getKey()) != null) continue;
            updatedFlagKeys.add(oldFlag.getKey());
        }
        this.notifyAllFlagsListeners(updatedFlagKeys);
        this.notifyFlagListeners(updatedFlagKeys);
    }

    public void initDataFromJson(@NonNull LDContext context, @NonNull String newDataJson, Callback<Void> onCompleteListener) {
        EnvironmentData data;
        try {
            data = EnvironmentData.fromJson(newDataJson);
        }
        catch (Exception e) {
            this.logger.debug("Received invalid JSON flag data: {}", (Object)newDataJson);
            onCompleteListener.onError(new LDFailure("Invalid JSON received from flags endpoint", e, LDFailure.FailureType.INVALID_RESPONSE_BODY));
            return;
        }
        this.initData(this.currentContext, data);
        onCompleteListener.onSuccess(null);
    }

    @Nullable
    public DataModel.Flag getNonDeletedFlag(@NonNull String key) {
        DataModel.Flag ret = this.flags.getFlag(key);
        return ret == null || ret.isDeleted() ? null : ret;
    }

    @NonNull
    public EnvironmentData getAllNonDeleted() {
        EnvironmentData data = this.flags;
        for (DataModel.Flag f : data.values()) {
            if (!f.isDeleted()) continue;
            HashMap<String, DataModel.Flag> filtered = new HashMap<String, DataModel.Flag>();
            for (DataModel.Flag f1 : data.values()) {
                if (f1.isDeleted()) continue;
                filtered.put(f1.getKey(), f1);
            }
            return EnvironmentData.usingExistingFlagsMap(filtered);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upsert(@NonNull DataModel.Flag flag) {
        String contextId;
        EnvironmentData updatedFlags;
        Object object = this.writerLock;
        synchronized (object) {
            DataModel.Flag oldFlag = this.flags.getFlag(flag.getKey());
            if (oldFlag != null && oldFlag.getVersion() >= flag.getVersion()) {
                return false;
            }
            this.flags = updatedFlags = this.flags.withFlagUpdatedOrAdded(flag);
            contextId = this.flagsContextId;
        }
        this.environmentStore.setContextData(contextId, updatedFlags);
        this.notifyFlagListeners(Collections.singletonList(flag.getKey()));
        return true;
    }

    public void registerListener(String key, FeatureFlagChangeListener listener) {
        ConcurrentHashMap backingMap = new ConcurrentHashMap();
        Set newSet = Collections.newSetFromMap(backingMap);
        newSet.add(listener);
        Set oldSet = this.listeners.putIfAbsent(key, newSet);
        if (oldSet != null) {
            oldSet.add(listener);
            this.logger.debug("Added listener. Total count: [{}]", (Object)oldSet.size());
        } else {
            this.logger.debug((Object)"Added listener. Total count: 1");
        }
    }

    public void unregisterListener(String key, FeatureFlagChangeListener listener) {
        boolean removed;
        Set<FeatureFlagChangeListener> keySet = this.listeners.get(key);
        if (keySet != null && (removed = keySet.remove(listener))) {
            this.logger.debug("Removing listener for key: [{}]", (Object)key);
        }
    }

    public void registerAllFlagsListener(LDAllFlagsListener listener) {
        this.allFlagsListeners.add(listener);
    }

    public void unregisterAllFlagsListener(LDAllFlagsListener listener) {
        this.allFlagsListeners.remove(listener);
    }

    public Collection<FeatureFlagChangeListener> getListenersByKey(String key) {
        HashSet res = this.listeners.get(key);
        return res == null ? new HashSet() : res;
    }

    public static String hashedContextId(LDContext context) {
        return HASHER.hash(context.getFullyQualifiedKey());
    }

    private void notifyFlagListeners(Collection<String> updatedFlagKeys) {
        if (updatedFlagKeys == null || updatedFlagKeys.isEmpty()) {
            return;
        }
        HashMap<String, Set<FeatureFlagChangeListener>> listenersToCall = new HashMap<String, Set<FeatureFlagChangeListener>>();
        for (String flagKey : updatedFlagKeys) {
            Set<FeatureFlagChangeListener> flagListeners = this.listeners.get(flagKey);
            if (flagListeners == null || flagListeners.isEmpty()) continue;
            listenersToCall.put(flagKey, flagListeners);
        }
        if (listenersToCall.isEmpty()) {
            return;
        }
        this.taskExecutor.executeOnMainThread(() -> {
            for (Map.Entry flagListeners : listenersToCall.entrySet()) {
                for (FeatureFlagChangeListener listener : (Set)flagListeners.getValue()) {
                    listener.onFeatureFlagChange((String)flagListeners.getKey());
                }
            }
        });
    }

    private void notifyAllFlagsListeners(Collection<String> updatedFlagKeys) {
        if (updatedFlagKeys == null || updatedFlagKeys.isEmpty() || this.allFlagsListeners.isEmpty()) {
            return;
        }
        ArrayList<String> keysAsList = new ArrayList<String>(updatedFlagKeys);
        this.taskExecutor.executeOnMainThread(() -> {
            for (LDAllFlagsListener listener : this.allFlagsListeners) {
                listener.onChange(keysAsList);
            }
        });
    }
}

