/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.ContextMultiBuilder;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.PersistentDataStoreWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

final class ContextDecorator {
    private static final String GENERATED_KEY_SHARED_PREFS_PREFIX = "anon-key-";
    @NonNull
    private final PersistentDataStoreWrapper persistentData;
    private final boolean generateAnonymousKeys;
    private Map<ContextKind, String> cachedGeneratedKey = new HashMap<ContextKind, String>();
    private Object generatedKeyLock = new Object();

    public ContextDecorator(@NonNull PersistentDataStoreWrapper persistentData, boolean generateAnonymousKeys) {
        this.persistentData = persistentData;
        this.generateAnonymousKeys = generateAnonymousKeys;
    }

    public LDContext decorateContext(LDContext context, LDLogger logger) {
        if (!this.generateAnonymousKeys) {
            return context;
        }
        if (context.isMultiple()) {
            boolean hasAnyAnon = false;
            for (int i = 0; i < context.getIndividualContextCount(); ++i) {
                if (!context.getIndividualContext(i).isAnonymous()) continue;
                hasAnyAnon = true;
                break;
            }
            if (hasAnyAnon) {
                ContextMultiBuilder builder = LDContext.multiBuilder();
                for (int i = 0; i < context.getIndividualContextCount(); ++i) {
                    LDContext c = context.getIndividualContext(i);
                    builder.add(c.isAnonymous() ? this.singleKindContextWithGeneratedKey(c, logger) : c);
                }
                return builder.build();
            }
        } else if (context.isAnonymous()) {
            return this.singleKindContextWithGeneratedKey(context, logger);
        }
        return context;
    }

    private LDContext singleKindContextWithGeneratedKey(LDContext context, LDLogger logger) {
        return LDContext.builderFromContext((LDContext)context).key(this.getOrCreateAutoContextKey(context.getKind(), logger)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrCreateAutoContextKey(final ContextKind contextKind, LDLogger logger) {
        Object object = this.generatedKeyLock;
        synchronized (object) {
            String key = this.cachedGeneratedKey.get(contextKind);
            if (key != null) {
                return key;
            }
            key = this.persistentData.getGeneratedContextKey(contextKind);
            if (key != null) {
                this.cachedGeneratedKey.put(contextKind, key);
                return key;
            }
            final String generatedKey = UUID.randomUUID().toString();
            this.cachedGeneratedKey.put(contextKind, generatedKey);
            logger.info("Did not find a generated anonymous key for context kind \"{}\". Generating a new one: {}", (Object)contextKind, (Object)generatedKey);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ContextDecorator.this.persistentData.setGeneratedContextKey(contextKind, generatedKey);
                }
            }).run();
            return generatedKey;
        }
    }
}

