/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.Logs;
import com.launchdarkly.sdk.android.Components;
import com.launchdarkly.sdk.android.LDTimberLogging;
import com.launchdarkly.sdk.android.integrations.ApplicationInfoBuilder;
import com.launchdarkly.sdk.android.integrations.ServiceEndpointsBuilder;
import com.launchdarkly.sdk.android.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.android.subsystems.ApplicationInfo;
import com.launchdarkly.sdk.android.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.android.subsystems.DataSource;
import com.launchdarkly.sdk.android.subsystems.EventProcessor;
import com.launchdarkly.sdk.android.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.android.subsystems.PersistentDataStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import okhttp3.MediaType;

public class LDConfig {
    public static final int DEFAULT_BACKGROUND_POLL_INTERVAL_MILLIS = 3600000;
    public static final int MIN_BACKGROUND_POLL_INTERVAL_MILLIS = 900000;
    static final String DEFAULT_LOGGER_NAME = "LaunchDarklySdk";
    static final LDLogLevel DEFAULT_LOG_LEVEL = LDLogLevel.INFO;
    static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    static final String primaryEnvironmentName = "default";
    static final int DEFAULT_MAX_CACHED_CONTEXTS = 5;
    static final int DEFAULT_CONNECTION_TIMEOUT_MILLIS = 10000;
    private final Map<String, String> mobileKeys;
    final ServiceEndpoints serviceEndpoints;
    final ApplicationInfo applicationInfo;
    final ComponentConfigurer<DataSource> dataSource;
    final ComponentConfigurer<EventProcessor> events;
    final ComponentConfigurer<HttpConfiguration> http;
    private final boolean diagnosticOptOut;
    private final boolean disableBackgroundUpdating;
    private final boolean evaluationReasons;
    private final boolean generateAnonymousKeys;
    private final LDLogAdapter logAdapter;
    private final String loggerName;
    private final int maxCachedContexts;
    private final boolean offline;
    private final PersistentDataStore persistentDataStore;

    LDConfig(Map<String, String> mobileKeys, ServiceEndpoints serviceEndpoints, ApplicationInfo applicationInfo, ComponentConfigurer<DataSource> dataSource, ComponentConfigurer<EventProcessor> events, ComponentConfigurer<HttpConfiguration> http, boolean offline, boolean disableBackgroundUpdating, boolean evaluationReasons, boolean diagnosticOptOut, int maxCachedContexts, boolean generateAnonymousKeys, PersistentDataStore persistentDataStore, LDLogAdapter logAdapter, String loggerName) {
        this.mobileKeys = mobileKeys;
        this.serviceEndpoints = serviceEndpoints;
        this.applicationInfo = applicationInfo;
        this.dataSource = dataSource;
        this.events = events;
        this.http = http;
        this.offline = offline;
        this.disableBackgroundUpdating = disableBackgroundUpdating;
        this.evaluationReasons = evaluationReasons;
        this.diagnosticOptOut = diagnosticOptOut;
        this.maxCachedContexts = maxCachedContexts;
        this.generateAnonymousKeys = generateAnonymousKeys;
        this.persistentDataStore = persistentDataStore;
        this.logAdapter = logAdapter;
        this.loggerName = loggerName;
    }

    public String getMobileKey() {
        return this.mobileKeys.get(primaryEnvironmentName);
    }

    public Map<String, String> getMobileKeys() {
        return this.mobileKeys;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isDisableBackgroundPolling() {
        return this.disableBackgroundUpdating;
    }

    public boolean isEvaluationReasons() {
        return this.evaluationReasons;
    }

    boolean getDiagnosticOptOut() {
        return this.diagnosticOptOut;
    }

    int getMaxCachedContexts() {
        return this.maxCachedContexts;
    }

    public boolean isGenerateAnonymousKeys() {
        return this.generateAnonymousKeys;
    }

    PersistentDataStore getPersistentDataStore() {
        return this.persistentDataStore;
    }

    LDLogAdapter getLogAdapter() {
        return this.logAdapter;
    }

    String getLoggerName() {
        return this.loggerName;
    }

    public static class Builder {
        private String mobileKey;
        private Map<String, String> secondaryMobileKeys;
        private ServiceEndpointsBuilder serviceEndpointsBuilder;
        private ApplicationInfoBuilder applicationInfoBuilder = null;
        private ComponentConfigurer<DataSource> dataSource = null;
        private ComponentConfigurer<EventProcessor> events = null;
        private ComponentConfigurer<HttpConfiguration> http = null;
        private int maxCachedContexts = 5;
        private boolean offline = false;
        private boolean disableBackgroundUpdating = false;
        private boolean diagnosticOptOut = false;
        private boolean evaluationReasons = false;
        private boolean generateAnonymousKeys;
        private PersistentDataStore persistentDataStore;
        private LDLogAdapter logAdapter = Builder.defaultLogAdapter();
        private String loggerName = "LaunchDarklySdk";
        private LDLogLevel logLevel = null;

        public Builder mobileKey(String mobileKey) {
            if (this.secondaryMobileKeys != null && this.secondaryMobileKeys.containsValue(mobileKey)) {
                throw new IllegalArgumentException("The primary environment key cannot be in the secondary mobile keys.");
            }
            this.mobileKey = mobileKey;
            return this;
        }

        public Builder secondaryMobileKeys(Map<String, String> secondaryMobileKeys) {
            if (secondaryMobileKeys == null) {
                this.secondaryMobileKeys = null;
                return this;
            }
            Map<String, String> unmodifiable = Collections.unmodifiableMap(secondaryMobileKeys);
            if (unmodifiable.containsKey(LDConfig.primaryEnvironmentName)) {
                throw new IllegalArgumentException("The primary environment name is not a valid key.");
            }
            HashSet<String> secondaryKeys = new HashSet<String>(unmodifiable.values());
            if (this.mobileKey != null && secondaryKeys.contains(this.mobileKey)) {
                throw new IllegalArgumentException("The primary environment key cannot be in the secondary mobile keys.");
            }
            if (unmodifiable.values().size() != secondaryKeys.size()) {
                throw new IllegalArgumentException("A key can only be used once.");
            }
            this.secondaryMobileKeys = unmodifiable;
            return this;
        }

        public Builder serviceEndpoints(ServiceEndpointsBuilder serviceEndpointsBuilder) {
            this.serviceEndpointsBuilder = serviceEndpointsBuilder;
            return this;
        }

        public Builder applicationInfo(ApplicationInfoBuilder applicationInfoBuilder) {
            this.applicationInfoBuilder = applicationInfoBuilder;
            return this;
        }

        public Builder dataSource(ComponentConfigurer<DataSource> dataSourceConfigurer) {
            this.dataSource = dataSourceConfigurer;
            return this;
        }

        public Builder events(ComponentConfigurer<EventProcessor> eventsConfigurer) {
            this.events = eventsConfigurer;
            return this;
        }

        public Builder http(ComponentConfigurer<HttpConfiguration> httpConfigurer) {
            this.http = httpConfigurer;
            return this;
        }

        public Builder disableBackgroundUpdating(boolean disableBackgroundUpdating) {
            this.disableBackgroundUpdating = disableBackgroundUpdating;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder evaluationReasons(boolean evaluationReasons) {
            this.evaluationReasons = evaluationReasons;
            return this;
        }

        public Builder diagnosticOptOut(boolean diagnosticOptOut) {
            this.diagnosticOptOut = diagnosticOptOut;
            return this;
        }

        public Builder maxCachedContexts(int maxCachedContexts) {
            this.maxCachedContexts = maxCachedContexts;
            return this;
        }

        public Builder generateAnonymousKeys(boolean generateAnonymousKeys) {
            this.generateAnonymousKeys = generateAnonymousKeys;
            return this;
        }

        Builder persistentDataStore(PersistentDataStore persistentDataStore) {
            this.persistentDataStore = persistentDataStore;
            return this;
        }

        public Builder logAdapter(LDLogAdapter logAdapter) {
            this.logAdapter = logAdapter == null ? Builder.defaultLogAdapter() : logAdapter;
            return this;
        }

        public Builder logLevel(LDLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder loggerName(String loggerName) {
            this.loggerName = loggerName == null ? LDConfig.DEFAULT_LOGGER_NAME : loggerName;
            return this;
        }

        private static LDLogAdapter defaultLogAdapter() {
            return LDTimberLogging.adapter();
        }

        public LDConfig build() {
            LDLogAdapter actualLogAdapter = Logs.level((LDLogAdapter)this.logAdapter, (LDLogLevel)(this.logLevel == null ? DEFAULT_LOG_LEVEL : this.logLevel));
            HashMap<String, String> mobileKeys = this.secondaryMobileKeys == null ? new HashMap<String, String>() : new HashMap<String, String>(this.secondaryMobileKeys);
            mobileKeys.put(LDConfig.primaryEnvironmentName, this.mobileKey);
            ServiceEndpoints serviceEndpoints = (this.serviceEndpointsBuilder == null ? Components.serviceEndpoints() : this.serviceEndpointsBuilder).createServiceEndpoints();
            ApplicationInfo applicationInfo = this.applicationInfoBuilder == null ? Components.applicationInfo().createApplicationInfo() : this.applicationInfoBuilder.createApplicationInfo();
            return new LDConfig(mobileKeys, serviceEndpoints, applicationInfo, this.dataSource == null ? Components.streamingDataSource() : this.dataSource, this.events == null ? Components.sendEvents() : this.events, this.http == null ? Components.httpConfiguration() : this.http, this.offline, this.disableBackgroundUpdating, this.evaluationReasons, this.diagnosticOptOut, this.maxCachedContexts, this.generateAnonymousKeys, this.persistentDataStore, actualLogAdapter, this.loggerName);
        }
    }
}

