/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import android.util.Base64;
import androidx.annotation.NonNull;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.subsystems.ApplicationInfo;
import com.launchdarkly.sdk.android.subsystems.Callback;
import com.launchdarkly.sdk.android.subsystems.ClientContext;
import com.launchdarkly.sdk.android.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.internal.http.HeadersTransformer;
import com.launchdarkly.sdk.internal.http.HttpProperties;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import okhttp3.Headers;

class LDUtil {
    static final String AUTH_SCHEME = "api_key ";
    static final String USER_AGENT_HEADER_VALUE = "AndroidClient/4.2.0";
    private static Pattern TAG_VALUE_REGEX = Pattern.compile("^[-a-zA-Z0-9._]+$");

    LDUtil() {
    }

    static <T> Callback<T> noOpCallback() {
        return new Callback<T>(){

            @Override
            public void onSuccess(T result) {
            }

            @Override
            public void onError(Throwable error) {
            }
        };
    }

    static String applicationTagHeader(ApplicationInfo applicationInfo, LDLogger logger) {
        String[][] tags = new String[][]{{"applicationId", "application-id", applicationInfo.getApplicationId()}, {"applicationVersion", "application-version", applicationInfo.getApplicationVersion()}};
        ArrayList<String> parts = new ArrayList<String>();
        for (String[] row : tags) {
            String javaKey = row[0];
            String tagKey = row[1];
            String tagVal = row[2];
            if (tagVal == null) continue;
            if (!TAG_VALUE_REGEX.matcher(tagVal).matches()) {
                logger.warn("Value of ApplicationInfo.{} contained invalid characters and was discarded", (Object)javaKey);
                continue;
            }
            if (tagVal.length() > 64) {
                logger.warn("Value of ApplicationInfo.{} was longer than 64 characters and was discarded", (Object)javaKey);
                continue;
            }
            parts.add(tagKey + "/" + tagVal);
        }
        return String.join((CharSequence)" ", parts);
    }

    static Headers makeRequestHeaders(@NonNull HttpConfiguration httpConfig, Map<String, String> additionalHeaders) {
        HashMap<String, String> baseHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : httpConfig.getDefaultHeaders()) {
            baseHeaders.put(kv.getKey(), kv.getValue());
        }
        if (additionalHeaders != null) {
            baseHeaders.putAll(additionalHeaders);
        }
        if (httpConfig.getHeaderTransform() != null) {
            httpConfig.getHeaderTransform().updateHeaders(baseHeaders);
        }
        return Headers.of(baseHeaders);
    }

    static String urlSafeBase64Hash(String input) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(input.getBytes(Charset.forName("UTF-8")));
            return Base64.encodeToString((byte[])hash, (int)10);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static String base64Url(LDContext context) {
        return Base64.encodeToString((byte[])JsonSerialization.serialize((JsonSerializable)context).getBytes(), (int)10);
    }

    static HttpProperties makeHttpProperties(ClientContext clientContext) {
        final HttpConfiguration httpConfig = clientContext.getHttp();
        HashMap<String, String> baseHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : httpConfig.getDefaultHeaders()) {
            baseHeaders.put(kv.getKey(), kv.getValue());
        }
        HeadersTransformer headersTransformer = null;
        if (httpConfig.getHeaderTransform() != null) {
            headersTransformer = new HeadersTransformer(){

                public void updateHeaders(Map<String, String> headers) {
                    httpConfig.getHeaderTransform().updateHeaders(headers);
                }
            };
        }
        return new HttpProperties((long)httpConfig.getConnectTimeoutMillis(), baseHeaders, headersTransformer, null, null, null, (long)httpConfig.getConnectTimeoutMillis(), null, null);
    }

    static boolean isHttpErrorRecoverable(int statusCode) {
        if (statusCode >= 400 && statusCode < 500) {
            switch (statusCode) {
                case 400: 
                case 408: 
                case 429: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    static void logExceptionAtErrorLevel(LDLogger logger, Throwable ex, String msgFormat, Object ... msgArgs) {
        LDUtil.logException(logger, ex, true, msgFormat, msgArgs);
    }

    static void logExceptionAtWarnLevel(LDLogger logger, Throwable ex, String msgFormat, Object ... msgArgs) {
        LDUtil.logException(logger, ex, false, msgFormat, msgArgs);
    }

    private static void logException(LDLogger logger, Throwable ex, boolean asError, String msgFormat, Object ... msgArgs) {
        String addFormat = msgFormat + " - {}";
        Object exSummary = LogValues.exceptionSummary((Throwable)ex);
        Object[] args = Arrays.copyOf(msgArgs, msgArgs.length + 1);
        args[msgArgs.length] = exSummary;
        if (asError) {
            logger.error(addFormat, args);
        } else {
            logger.warn(addFormat, args);
        }
        logger.debug(LogValues.exceptionTrace((Throwable)ex));
    }
}

