/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.eventsource.UnsuccessfulResponseException;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.BackgroundThreadExecutor;
import com.launchdarkly.sdk.android.ClientContextImpl;
import com.launchdarkly.sdk.android.ConnectivityManager;
import com.launchdarkly.sdk.android.DataModel;
import com.launchdarkly.sdk.android.EnvironmentData;
import com.launchdarkly.sdk.android.FeatureFetcher;
import com.launchdarkly.sdk.android.LDConfig;
import com.launchdarkly.sdk.android.LDFailure;
import com.launchdarkly.sdk.android.LDInvalidResponseCodeFailure;
import com.launchdarkly.sdk.android.LDUtil;
import com.launchdarkly.sdk.android.subsystems.Callback;
import com.launchdarkly.sdk.android.subsystems.ClientContext;
import com.launchdarkly.sdk.android.subsystems.DataSource;
import com.launchdarkly.sdk.android.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.internal.GsonHelpers;
import com.launchdarkly.sdk.internal.events.DiagnosticStore;
import com.launchdarkly.sdk.internal.http.HttpHelpers;
import com.launchdarkly.sdk.internal.http.HttpProperties;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import com.launchdarkly.sdk.json.SerializationException;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

final class StreamingDataSource
implements DataSource {
    private static final String METHOD_REPORT = "REPORT";
    private static final String PING = "ping";
    private static final String PUT = "put";
    private static final String PATCH = "patch";
    private static final String DELETE = "delete";
    private static final long MAX_RECONNECT_TIME_MS = 3600000L;
    private static final long READ_TIMEOUT_MS = 300000L;
    private EventSource es;
    private final LDContext currentContext;
    private final HttpProperties httpProperties;
    private final boolean evaluationReasons;
    final int initialReconnectDelayMillis;
    private final boolean useReport;
    private final URI streamUri;
    private final DataSourceUpdateSink dataSourceUpdateSink;
    private final FeatureFetcher fetcher;
    private final boolean streamEvenInBackground;
    private volatile boolean running = false;
    private boolean connection401Error = false;
    private final ExecutorService executor;
    private final DiagnosticStore diagnosticStore;
    private long eventSourceStarted;
    private final LDLogger logger;

    StreamingDataSource(@NonNull ClientContext clientContext, @NonNull LDContext currentContext, @NonNull DataSourceUpdateSink dataSourceUpdateSink, @NonNull FeatureFetcher fetcher, int initialReconnectDelayMillis, boolean streamEvenInBackground) {
        this.currentContext = currentContext;
        this.dataSourceUpdateSink = dataSourceUpdateSink;
        this.fetcher = fetcher;
        this.streamUri = clientContext.getServiceEndpoints().getStreamingBaseUri();
        this.httpProperties = LDUtil.makeHttpProperties(clientContext);
        this.evaluationReasons = clientContext.isEvaluationReasons();
        this.useReport = clientContext.getHttp().isUseReport();
        this.initialReconnectDelayMillis = initialReconnectDelayMillis;
        this.streamEvenInBackground = streamEvenInBackground;
        this.diagnosticStore = ClientContextImpl.get(clientContext).getDiagnosticStore();
        this.logger = clientContext.getBaseLogger();
        this.executor = new BackgroundThreadExecutor().newFixedThreadPool(2);
    }

    @Override
    public void start(final @NonNull Callback<Boolean> resultCallback) {
        if (!this.running && !this.connection401Error) {
            this.logger.debug((Object)"Starting.");
            EventHandler handler = new EventHandler(){

                public void onOpen() {
                    StreamingDataSource.this.logger.info((Object)"Started LaunchDarkly EventStream");
                    if (StreamingDataSource.this.diagnosticStore != null) {
                        StreamingDataSource.this.diagnosticStore.recordStreamInit(StreamingDataSource.this.eventSourceStarted, (long)((int)(System.currentTimeMillis() - StreamingDataSource.this.eventSourceStarted)), false);
                    }
                }

                public void onClosed() {
                    StreamingDataSource.this.logger.info((Object)"Closed LaunchDarkly EventStream");
                }

                public void onMessage(String name, MessageEvent event) {
                    String eventData = event.getData();
                    StreamingDataSource.this.logger.debug("onMessage: {}: {}", (Object)name, (Object)eventData);
                    StreamingDataSource.this.handle(name, eventData, resultCallback);
                }

                public void onComment(String comment) {
                }

                public void onError(Throwable t) {
                    LDUtil.logExceptionAtErrorLevel(StreamingDataSource.this.logger, t, "Encountered EventStream error connecting to URI: {}", StreamingDataSource.this.getUri(StreamingDataSource.this.currentContext));
                    if (t instanceof UnsuccessfulResponseException) {
                        int code;
                        if (StreamingDataSource.this.diagnosticStore != null) {
                            StreamingDataSource.this.diagnosticStore.recordStreamInit(StreamingDataSource.this.eventSourceStarted, (long)((int)(System.currentTimeMillis() - StreamingDataSource.this.eventSourceStarted)), true);
                        }
                        if ((code = ((UnsuccessfulResponseException)t).getCode()) >= 400 && code < 500) {
                            StreamingDataSource.this.logger.error("Encountered non-retriable error: {}. Aborting connection to stream. Verify correct Mobile Key and Stream URI", (Object)code);
                            StreamingDataSource.this.running = false;
                            resultCallback.onError(new LDInvalidResponseCodeFailure("Unexpected Response Code From Stream Connection", t, code, false));
                            if (code == 401) {
                                StreamingDataSource.this.connection401Error = true;
                                StreamingDataSource.this.dataSourceUpdateSink.shutDown();
                            }
                            StreamingDataSource.this.stop(null);
                        } else {
                            StreamingDataSource.this.eventSourceStarted = System.currentTimeMillis();
                            resultCallback.onError(new LDInvalidResponseCodeFailure("Unexpected Response Code From Stream Connection", t, code, true));
                        }
                    } else {
                        resultCallback.onError(new LDFailure("Network error in stream connection", t, LDFailure.FailureType.NETWORK_FAILURE));
                    }
                }
            };
            EventSource.Builder builder = new EventSource.Builder(handler, this.getUri(this.currentContext));
            builder.reconnectTime((long)this.initialReconnectDelayMillis, TimeUnit.MILLISECONDS);
            builder.clientBuilderActions(new EventSource.Builder.ClientConfigurer(){

                public void configure(OkHttpClient.Builder clientBuilder) {
                    StreamingDataSource.this.httpProperties.applyToHttpClientBuilder(clientBuilder);
                    clientBuilder.readTimeout(300000L, TimeUnit.MILLISECONDS);
                }
            });
            builder.requestTransformer(input -> input.newBuilder().headers(input.headers().newBuilder().addAll(this.httpProperties.toHeadersBuilder().build()).build()).build());
            if (this.useReport) {
                builder.method(METHOD_REPORT);
                builder.body(this.getRequestBody(this.currentContext));
            }
            builder.maxReconnectTime(3600000L, TimeUnit.MILLISECONDS);
            this.eventSourceStarted = System.currentTimeMillis();
            this.es = builder.build();
            this.es.start();
            this.running = true;
        }
    }

    @NonNull
    private RequestBody getRequestBody(@Nullable LDContext context) {
        this.logger.debug((Object)"Attempting to report user in stream");
        return RequestBody.create((String)JsonSerialization.serialize((JsonSerializable)context), (MediaType)LDConfig.JSON);
    }

    private URI getUri(@Nullable LDContext context) {
        URI uri = HttpHelpers.concatenateUriPath((URI)this.streamUri, (String)"/meval");
        if (!this.useReport && context != null) {
            uri = HttpHelpers.concatenateUriPath((URI)uri, (String)LDUtil.base64Url(context));
        }
        if (this.evaluationReasons) {
            uri = URI.create(uri.toString() + "?withReasons=true");
        }
        return uri;
    }

    private void handle(String name, String eventData, @NonNull Callback<Boolean> resultCallback) {
        switch (name.toLowerCase()) {
            case "put": {
                EnvironmentData data;
                try {
                    data = EnvironmentData.fromJson(eventData);
                }
                catch (Exception e) {
                    this.logger.debug("Received invalid JSON flag data: {}", (Object)eventData);
                    resultCallback.onError(new LDFailure("Invalid JSON received from flags endpoint", e, LDFailure.FailureType.INVALID_RESPONSE_BODY));
                    return;
                }
                this.dataSourceUpdateSink.init(data.getAll());
                resultCallback.onSuccess(true);
                break;
            }
            case "patch": {
                this.applyPatch(eventData, resultCallback);
                break;
            }
            case "delete": {
                this.applyDelete(eventData, resultCallback);
                break;
            }
            case "ping": {
                ConnectivityManager.fetchAndSetData(this.fetcher, this.currentContext, this.dataSourceUpdateSink, LDUtil.noOpCallback(), this.logger);
                break;
            }
            default: {
                this.logger.debug("Found an unknown stream protocol: {}", (Object)name);
                resultCallback.onError(new LDFailure("Unknown Stream Element Type", null, LDFailure.FailureType.UNEXPECTED_STREAM_ELEMENT_TYPE));
            }
        }
    }

    @Override
    public void stop(@NonNull Callback<Void> onCompleteListener) {
        this.logger.debug((Object)"Stopping.");
        this.executor.execute(() -> {
            this.stopSync();
            if (onCompleteListener != null) {
                onCompleteListener.onSuccess(null);
            }
        });
    }

    @Override
    public boolean needsRefresh(boolean newInBackground, LDContext newEvaluationContext) {
        return !newEvaluationContext.equals((Object)this.currentContext) || newInBackground && !this.streamEvenInBackground;
    }

    private synchronized void stopSync() {
        if (this.es != null) {
            this.es.close();
        }
        this.running = false;
        this.es = null;
        this.logger.debug((Object)"Stopped.");
    }

    private void applyPatch(String json, @NonNull Callback<Boolean> onCompleteListener) {
        DataModel.Flag flag;
        try {
            flag = DataModel.Flag.fromJson(json);
        }
        catch (SerializationException e) {
            this.logger.debug("Invalid PATCH payload: {}", (Object)json);
            onCompleteListener.onError(new LDFailure("Invalid PATCH payload", LDFailure.FailureType.INVALID_RESPONSE_BODY));
            return;
        }
        if (flag == null) {
            return;
        }
        this.dataSourceUpdateSink.upsert(flag);
        onCompleteListener.onSuccess(null);
    }

    private void applyDelete(String json, @NonNull Callback<Boolean> onCompleteListener) {
        DeleteMessage deleteMessage;
        try {
            deleteMessage = (DeleteMessage)GsonHelpers.gsonInstance().fromJson(json, DeleteMessage.class);
        }
        catch (Exception e) {
            this.logger.debug("Invalid DELETE payload: {}", (Object)json);
            onCompleteListener.onError(new LDFailure("Invalid DELETE payload", LDFailure.FailureType.INVALID_RESPONSE_BODY));
            return;
        }
        if (deleteMessage == null) {
            return;
        }
        this.dataSourceUpdateSink.upsert(DataModel.Flag.deletedItemPlaceholder(deleteMessage.key, deleteMessage.version));
        onCompleteListener.onSuccess(null);
    }

    private static final class DeleteMessage {
        private final String key;
        private final int version;

        DeleteMessage(String key, int version) {
            this.key = key;
            this.version = version;
        }
    }
}

