/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import com.launchdarkly.sdk.ContextMultiBuilder;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.IContextModifier;
import com.launchdarkly.sdk.android.PersistentDataStoreWrapper;

final class AnonymousKeyContextModifier
implements IContextModifier {
    @NonNull
    private final PersistentDataStoreWrapper persistentData;
    private final boolean generateAnonymousKeys;

    public AnonymousKeyContextModifier(@NonNull PersistentDataStoreWrapper persistentData, boolean generateAnonymousKeys) {
        this.persistentData = persistentData;
        this.generateAnonymousKeys = generateAnonymousKeys;
    }

    @Override
    public LDContext modifyContext(LDContext context) {
        if (!this.generateAnonymousKeys) {
            return context;
        }
        if (context.isMultiple()) {
            boolean hasAnyAnon = false;
            for (int i = 0; i < context.getIndividualContextCount(); ++i) {
                if (!context.getIndividualContext(i).isAnonymous()) continue;
                hasAnyAnon = true;
                break;
            }
            if (hasAnyAnon) {
                ContextMultiBuilder builder = LDContext.multiBuilder();
                for (int i = 0; i < context.getIndividualContextCount(); ++i) {
                    LDContext c = context.getIndividualContext(i);
                    builder.add(c.isAnonymous() ? this.singleKindContextWithGeneratedKey(c) : c);
                }
                return builder.build();
            }
        } else if (context.isAnonymous()) {
            return this.singleKindContextWithGeneratedKey(context);
        }
        return context;
    }

    private LDContext singleKindContextWithGeneratedKey(LDContext context) {
        return LDContext.builderFromContext((LDContext)context).key(this.persistentData.getOrGenerateContextKey(context.getKind())).build();
    }
}

