/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.android.ClientContextImpl;
import com.launchdarkly.sdk.android.Components;
import com.launchdarkly.sdk.android.ConnectionInformation;
import com.launchdarkly.sdk.android.EventUtil;
import com.launchdarkly.sdk.android.LDUtil;
import com.launchdarkly.sdk.android.PollingDataSource;
import com.launchdarkly.sdk.android.StandardEndpoints;
import com.launchdarkly.sdk.android.StreamingDataSource;
import com.launchdarkly.sdk.android.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.android.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.android.integrations.PollingDataSourceBuilder;
import com.launchdarkly.sdk.android.integrations.ServiceEndpointsBuilder;
import com.launchdarkly.sdk.android.integrations.StreamingDataSourceBuilder;
import com.launchdarkly.sdk.android.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.android.subsystems.ClientContext;
import com.launchdarkly.sdk.android.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.android.subsystems.DataSource;
import com.launchdarkly.sdk.android.subsystems.DiagnosticDescription;
import com.launchdarkly.sdk.android.subsystems.EventProcessor;
import com.launchdarkly.sdk.android.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.internal.events.DefaultEventProcessor;
import com.launchdarkly.sdk.internal.events.DefaultEventSender;
import com.launchdarkly.sdk.internal.events.Event;
import com.launchdarkly.sdk.internal.events.EventSender;
import com.launchdarkly.sdk.internal.events.EventsConfiguration;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

abstract class ComponentsImpl {
    static final ComponentConfigurer<EventProcessor> NULL_EVENT_PROCESSOR_FACTORY = new ComponentConfigurer<EventProcessor>(){

        @Override
        public EventProcessor build(ClientContext clientContext) {
            return NullEventProcessor.INSTANCE;
        }
    };

    private ComponentsImpl() {
    }

    static interface DataSourceRequiresFeatureFetcher {
    }

    static final class StreamingDataSourceBuilderImpl
    extends StreamingDataSourceBuilder
    implements DiagnosticDescription,
    DataSourceRequiresFeatureFetcher {
        StreamingDataSourceBuilderImpl() {
        }

        @Override
        public DataSource build(ClientContext clientContext) {
            if (clientContext.isInBackground() && !this.streamEvenInBackground) {
                return (DataSource)Components.pollingDataSource().backgroundPollIntervalMillis(this.backgroundPollIntervalMillis).pollIntervalMillis(this.backgroundPollIntervalMillis).build(clientContext);
            }
            clientContext.getDataSourceUpdateSink().setStatus(ConnectionInformation.ConnectionMode.STREAMING, null);
            ClientContextImpl clientContextImpl = ClientContextImpl.get(clientContext);
            return new StreamingDataSource(clientContext, clientContext.getEvaluationContext(), clientContext.getDataSourceUpdateSink(), clientContextImpl.getFetcher(), this.initialReconnectDelayMillis, this.streamEvenInBackground);
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.buildObject().put("streamingDisabled", false).put("backgroundPollingIntervalMillis", this.backgroundPollIntervalMillis).put("reconnectTimeMillis", this.initialReconnectDelayMillis).build();
        }
    }

    static final class PollingDataSourceBuilderImpl
    extends PollingDataSourceBuilder
    implements DiagnosticDescription,
    DataSourceRequiresFeatureFetcher {
        PollingDataSourceBuilderImpl() {
        }

        @Override
        public DataSource build(ClientContext clientContext) {
            clientContext.getDataSourceUpdateSink().setStatus(clientContext.isInBackground() ? ConnectionInformation.ConnectionMode.BACKGROUND_POLLING : ConnectionInformation.ConnectionMode.POLLING, null);
            int actualPollIntervalMillis = clientContext.isInBackground() ? this.backgroundPollIntervalMillis : this.pollIntervalMillis;
            int initialDelayMillis = clientContext.isInBackground() && Boolean.FALSE.equals(clientContext.getPreviouslyInBackground()) ? this.backgroundPollIntervalMillis : 0;
            ClientContextImpl clientContextImpl = ClientContextImpl.get(clientContext);
            return new PollingDataSource(clientContext.getEvaluationContext(), clientContext.getDataSourceUpdateSink(), initialDelayMillis, actualPollIntervalMillis, clientContextImpl.getFetcher(), clientContextImpl.getPlatformState(), clientContextImpl.getTaskExecutor(), clientContext.getBaseLogger());
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.buildObject().put("streamingDisabled", true).put("backgroundPollingIntervalMillis", this.backgroundPollIntervalMillis).put("pollingIntervalMillis", this.pollIntervalMillis).build();
        }

        public PollingDataSourceBuilder backgroundPollIntervalMillisNoMinimum(int backgroundPollIntervalMillis) {
            this.backgroundPollIntervalMillis = backgroundPollIntervalMillis;
            return this;
        }

        public PollingDataSourceBuilder pollIntervalMillisNoMinimum(int pollIntervalMillis) {
            this.pollIntervalMillis = pollIntervalMillis;
            return this;
        }
    }

    static final class HttpConfigurationBuilderImpl
    extends HttpConfigurationBuilder
    implements DiagnosticDescription {
        HttpConfigurationBuilderImpl() {
        }

        @Override
        public HttpConfiguration build(ClientContext clientContext) {
            LDLogger logger = clientContext.getBaseLogger();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "api_key " + clientContext.getMobileKey());
            headers.put("User-Agent", "AndroidClient/5.0.2");
            String tagHeader = LDUtil.applicationTagHeader(clientContext.getEnvironmentReporter().getApplicationInfo(), clientContext.getBaseLogger());
            if (!tagHeader.isEmpty()) {
                headers.put("X-LaunchDarkly-Tags", tagHeader);
            }
            if (this.wrapperName != null) {
                String wrapperId = this.wrapperVersion == null ? this.wrapperName : this.wrapperName + "/" + this.wrapperVersion;
                headers.put("X-LaunchDarkly-Wrapper", wrapperId);
            }
            return new HttpConfiguration(this.connectTimeoutMillis, headers, this.headerTransform, this.useReport);
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.buildObject().put("connectTimeoutMillis", this.connectTimeoutMillis).put("useReport", this.useReport).build();
        }
    }

    static final class EventProcessorBuilderImpl
    extends EventProcessorBuilder
    implements DiagnosticDescription {
        EventProcessorBuilderImpl() {
        }

        @Override
        public EventProcessor build(ClientContext clientContext) {
            ClientContextImpl clientContextImpl = ClientContextImpl.get(clientContext);
            EventsConfiguration eventsConfig = new EventsConfiguration(this.allAttributesPrivate, this.capacity, null, (long)this.diagnosticRecordingIntervalMillis, clientContextImpl.getDiagnosticStore(), (EventSender)new DefaultEventSender(LDUtil.makeHttpProperties(clientContext), "/mobile/events/bulk", "/mobile/events/diagnostic", 0L, clientContext.getBaseLogger()), 1, clientContext.getServiceEndpoints().getEventsBaseUri(), (long)this.flushIntervalMillis, clientContext.isInBackground(), true, (Collection)this.privateAttributes);
            return new DefaultEventProcessorWrapper(new DefaultEventProcessor(eventsConfig, EventUtil.makeEventsTaskExecutor(), 5, clientContext.getBaseLogger()));
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.buildObject().put("allAttributesPrivate", this.allAttributesPrivate).put("diagnosticRecordingIntervalMillis", this.diagnosticRecordingIntervalMillis).put("eventsCapacity", this.capacity).put("diagnosticRecordingIntervalMillis", this.diagnosticRecordingIntervalMillis).put("eventsFlushIntervalMillis", this.flushIntervalMillis).build();
        }

        private final class DefaultEventProcessorWrapper
        implements EventProcessor {
            private final DefaultEventProcessor eventProcessor;

            DefaultEventProcessorWrapper(DefaultEventProcessor eventProcessor) {
                this.eventProcessor = eventProcessor;
            }

            @Override
            public void recordEvaluationEvent(LDContext context, String flagKey, int flagVersion, int variation, LDValue value, EvaluationReason reason, LDValue defaultValue, boolean requireFullEvent, Long debugEventsUntilDate) {
                this.eventProcessor.sendEvent((Event)new Event.FeatureRequest(System.currentTimeMillis(), flagKey, context, flagVersion, variation, value, defaultValue, reason, null, requireFullEvent, debugEventsUntilDate, false));
            }

            @Override
            public void recordIdentifyEvent(LDContext context) {
                this.eventProcessor.sendEvent((Event)new Event.Identify(System.currentTimeMillis(), context));
            }

            @Override
            public void recordCustomEvent(LDContext context, String eventKey, LDValue data, Double metricValue) {
                this.eventProcessor.sendEvent((Event)new Event.Custom(System.currentTimeMillis(), eventKey, context, data, metricValue));
            }

            @Override
            public void setInBackground(boolean inBackground) {
                this.eventProcessor.setInBackground(inBackground);
            }

            @Override
            public void setOffline(boolean offline) {
                this.eventProcessor.setOffline(offline);
            }

            @Override
            public void flush() {
                this.eventProcessor.flushAsync();
            }

            @Override
            public void blockingFlush() {
                this.eventProcessor.flushBlocking();
            }

            @Override
            public void close() throws IOException {
                this.eventProcessor.close();
            }
        }
    }

    static final class NullEventProcessor
    implements EventProcessor {
        static final NullEventProcessor INSTANCE = new NullEventProcessor();

        private NullEventProcessor() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void blockingFlush() {
        }

        @Override
        public void setInBackground(boolean inBackground) {
        }

        @Override
        public void setOffline(boolean offline) {
        }

        @Override
        public void close() {
        }

        @Override
        public void recordEvaluationEvent(LDContext context, String flagKey, int flagVersion, int variation, LDValue value, EvaluationReason reason, LDValue defaultValue, boolean requireFullEvent, Long debugEventsUntilDate) {
        }

        @Override
        public void recordIdentifyEvent(LDContext context) {
        }

        @Override
        public void recordCustomEvent(LDContext context, String eventKey, LDValue data, Double metricValue) {
        }
    }

    static final class ServiceEndpointsBuilderImpl
    extends ServiceEndpointsBuilder {
        ServiceEndpointsBuilderImpl() {
        }

        @Override
        public ServiceEndpoints createServiceEndpoints() {
            if (this.streamingBaseUri == null && this.pollingBaseUri == null && this.eventsBaseUri == null) {
                return new ServiceEndpoints(StandardEndpoints.DEFAULT_STREAMING_BASE_URI, StandardEndpoints.DEFAULT_POLLING_BASE_URI, StandardEndpoints.DEFAULT_EVENTS_BASE_URI);
            }
            return new ServiceEndpoints(this.streamingBaseUri, this.pollingBaseUri, this.eventsBaseUri);
        }
    }
}

