/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.sdk.android.DataModel;
import com.launchdarkly.sdk.internal.GsonHelpers;
import com.launchdarkly.sdk.json.SerializationException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class EnvironmentData {
    static final Type FLAGS_MAP_TYPE = new TypeToken<Map<String, DataModel.Flag>>(){}.getType();
    @NonNull
    private final Map<String, DataModel.Flag> flags;

    public EnvironmentData() {
        this(new HashMap<String, DataModel.Flag>());
    }

    private EnvironmentData(Map<String, DataModel.Flag> flags) {
        this.flags = flags == null ? new HashMap() : flags;
    }

    public static EnvironmentData copyingFlagsMap(Map<String, DataModel.Flag> flags) {
        return new EnvironmentData((Map<String, DataModel.Flag>)(flags == null ? null : new HashMap<String, DataModel.Flag>(flags)));
    }

    public static EnvironmentData usingExistingFlagsMap(Map<String, DataModel.Flag> flags) {
        return new EnvironmentData(flags);
    }

    public DataModel.Flag getFlag(String key) {
        return this.flags.get(key);
    }

    public Map<String, DataModel.Flag> getAll() {
        return new HashMap<String, DataModel.Flag>(this.flags);
    }

    public Collection<DataModel.Flag> values() {
        return this.flags.values();
    }

    public EnvironmentData withFlagUpdatedOrAdded(DataModel.Flag flag) {
        if (flag == null) {
            return this;
        }
        HashMap<String, DataModel.Flag> newFlags = new HashMap<String, DataModel.Flag>(this.flags);
        newFlags.put(flag.getKey(), flag);
        return new EnvironmentData(newFlags);
    }

    public EnvironmentData withFlagRemoved(String key) {
        if (key == null || !this.flags.containsKey(key)) {
            return this;
        }
        HashMap<String, DataModel.Flag> newFlags = new HashMap<String, DataModel.Flag>(this.flags);
        newFlags.remove(key);
        return new EnvironmentData(newFlags);
    }

    public static EnvironmentData fromJson(String json) throws SerializationException {
        Map dataMap;
        try {
            dataMap = (Map)GsonHelpers.gsonInstance().fromJson(json, FLAGS_MAP_TYPE);
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
        for (Map.Entry e : dataMap.entrySet()) {
            DataModel.Flag f = (DataModel.Flag)e.getValue();
            if (f.getKey() != null) continue;
            f = new DataModel.Flag((String)e.getKey(), f.getValue(), f.getVersion(), f.getFlagVersion(), f.getVariation(), f.isTrackEvents(), f.isTrackReason(), f.getDebugEventsUntilDate(), f.getReason());
            dataMap.put((String)e.getKey(), f);
        }
        return new EnvironmentData(dataMap);
    }

    public String toJson() {
        return GsonHelpers.gsonInstance().toJson(this.flags);
    }
}

