/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import android.util.Log;
import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.SimpleFormat;

public abstract class LDAndroidLogging {
    public static LDLogAdapter adapter() {
        return new AdapterImpl(false);
    }

    static LDLogAdapter adapter(boolean overrideAndroidLogFilter) {
        return new AdapterImpl(overrideAndroidLogFilter);
    }

    static abstract class ChannelImplBase
    implements LDLogAdapter.Channel {
        protected final String tag;

        public ChannelImplBase(String tag) {
            this.tag = tag;
        }

        protected abstract void logInternal(LDLogLevel var1, String var2);

        public void log(LDLogLevel level, Object message) {
            if (this.isEnabled(level)) {
                this.logInternal(level, message == null ? null : message.toString());
            }
        }

        public void log(LDLogLevel level, String format, Object param) {
            if (this.isEnabled(level)) {
                this.logInternal(level, SimpleFormat.format((String)format, (Object)param));
            }
        }

        public void log(LDLogLevel level, String format, Object param1, Object param2) {
            if (this.isEnabled(level)) {
                this.logInternal(level, SimpleFormat.format((String)format, (Object)param1, (Object)param2));
            }
        }

        public void log(LDLogLevel level, String format, Object ... params) {
            if (this.isEnabled(level)) {
                this.logInternal(level, SimpleFormat.format((String)format, (Object[])params));
            }
        }
    }

    static final class AdapterImpl
    implements LDLogAdapter {
        private final boolean overrideAndroidLogFilter;

        AdapterImpl(boolean overrideAndroidLogFilter) {
            this.overrideAndroidLogFilter = overrideAndroidLogFilter;
        }

        public LDLogAdapter.Channel newChannel(String name) {
            return new ChannelImpl(name);
        }

        private final class ChannelImpl
        extends ChannelImplBase {
            public ChannelImpl(String tag) {
                super(tag);
            }

            public boolean isEnabled(LDLogLevel level) {
                return AdapterImpl.this.overrideAndroidLogFilter || Log.isLoggable((String)this.tag, (int)this.toAndroidLogLevel(level));
            }

            private int toAndroidLogLevel(LDLogLevel level) {
                switch (level) {
                    case DEBUG: {
                        return 3;
                    }
                    case INFO: {
                        return 4;
                    }
                    case WARN: {
                        return 5;
                    }
                    case ERROR: {
                        return 6;
                    }
                }
                return 2;
            }

            @Override
            protected void logInternal(LDLogLevel level, String text) {
                switch (level) {
                    case DEBUG: {
                        Log.d((String)this.tag, (String)text);
                        break;
                    }
                    case INFO: {
                        Log.i((String)this.tag, (String)text);
                        break;
                    }
                    case WARN: {
                        Log.w((String)this.tag, (String)text);
                        break;
                    }
                    case ERROR: {
                        Log.e((String)this.tag, (String)text);
                    }
                }
            }
        }
    }
}

