/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogger;
import java.net.URI;

abstract class StandardEndpoints {
    static final URI DEFAULT_STREAMING_BASE_URI = URI.create("https://clientstream.launchdarkly.com");
    static final URI DEFAULT_POLLING_BASE_URI = URI.create("https://clientsdk.launchdarkly.com");
    static final URI DEFAULT_EVENTS_BASE_URI = URI.create("https://mobile.launchdarkly.com");
    static final String STREAMING_REQUEST_BASE_PATH = "/meval";
    static final String POLLING_REQUEST_GET_BASE_PATH = "/msdk/evalx/contexts";
    static final String POLLING_REQUEST_REPORT_BASE_PATH = "/msdk/evalx/context";
    static final String ANALYTICS_EVENTS_REQUEST_PATH = "/mobile/events/bulk";
    static final String DIAGNOSTIC_EVENTS_REQUEST_PATH = "/mobile/events/diagnostic";

    private StandardEndpoints() {
    }

    static URI selectBaseUri(URI serviceEndpointsValue, URI defaultValue, String description, LDLogger logger) {
        if (serviceEndpointsValue != null) {
            return serviceEndpointsValue;
        }
        logger.warn("You have set custom ServiceEndpoints without specifying the {} base URI; connections may not work properly", (Object)description);
        return defaultValue;
    }

    static boolean isCustomBaseUri(URI serviceEndpointsValue, URI defaultValue) {
        return serviceEndpointsValue != null && !serviceEndpointsValue.equals(defaultValue);
    }
}

