/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android.env;

import android.app.Application;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import com.launchdarkly.sdk.android.env.EnvironmentReporterChainBase;
import com.launchdarkly.sdk.android.env.IEnvironmentReporter;
import com.launchdarkly.sdk.android.integrations.ApplicationInfoBuilder;
import java.util.Locale;

class AndroidEnvironmentReporter
extends EnvironmentReporterChainBase
implements IEnvironmentReporter {
    @NonNull
    private final Application application;

    public AndroidEnvironmentReporter(Application application) {
        this.application = application;
    }

    @Override
    @NonNull
    public com.launchdarkly.sdk.android.subsystems.ApplicationInfo getApplicationInfo() {
        ApplicationInfoBuilder builder = new ApplicationInfoBuilder();
        builder.applicationId(this.getApplicationID());
        builder.applicationVersion(this.getApplicationVersion());
        builder.applicationName(this.getApplicationName());
        builder.applicationVersionName(this.getApplicationVersionName());
        com.launchdarkly.sdk.android.subsystems.ApplicationInfo info = builder.createApplicationInfo();
        if (info.getApplicationId() == null) {
            info = super.getApplicationInfo();
        }
        return info;
    }

    @Override
    @NonNull
    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    @Override
    @NonNull
    public String getModel() {
        return Build.MODEL;
    }

    @Override
    @NonNull
    public String getLocale() {
        Locale locale = Build.VERSION.SDK_INT >= 24 ? this.application.getResources().getConfiguration().getLocales().get(0) : this.application.getResources().getConfiguration().locale;
        return locale.toLanguageTag();
    }

    @Override
    @NonNull
    public String getOSFamily() {
        return "Android";
    }

    @Override
    @NonNull
    public String getOSName() {
        return "Android" + Build.VERSION.SDK_INT;
    }

    @Override
    @NonNull
    public String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    private String getApplicationID() {
        return this.application.getPackageName();
    }

    private String getApplicationName() {
        try {
            PackageManager pm = this.application.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(this.application.getPackageName(), 0);
            return pm.getApplicationLabel(ai).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            return super.getApplicationInfo().getApplicationName();
        }
    }

    private String getApplicationVersion() {
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                return String.valueOf(this.application.getPackageManager().getPackageInfo(this.application.getPackageName(), 0).getLongVersionCode());
            }
            return String.valueOf(this.application.getPackageManager().getPackageInfo((String)this.application.getPackageName(), (int)0).versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private String getApplicationVersionName() {
        try {
            PackageManager pm = this.application.getPackageManager();
            return pm.getPackageInfo((String)this.application.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }
}

