/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.EventUtil;
import com.launchdarkly.sdk.android.FeatureFetcher;
import com.launchdarkly.sdk.android.LDConfig;
import com.launchdarkly.sdk.android.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.android.PlatformState;
import com.launchdarkly.sdk.android.TaskExecutor;
import com.launchdarkly.sdk.android.env.IEnvironmentReporter;
import com.launchdarkly.sdk.android.subsystems.ClientContext;
import com.launchdarkly.sdk.android.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.android.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.internal.events.DiagnosticStore;

final class ClientContextImpl
extends ClientContext {
    private final DiagnosticStore diagnosticStore;
    private final FeatureFetcher fetcher;
    private final PlatformState platformState;
    private final TaskExecutor taskExecutor;
    private final PersistentDataStoreWrapper.PerEnvironmentData perEnvironmentData;

    ClientContextImpl(ClientContext base, DiagnosticStore diagnosticStore, FeatureFetcher fetcher, PlatformState platformState, TaskExecutor taskExecutor, PersistentDataStoreWrapper.PerEnvironmentData perEnvironmentData) {
        super(base);
        this.diagnosticStore = diagnosticStore;
        this.fetcher = fetcher;
        this.platformState = platformState;
        this.taskExecutor = taskExecutor;
        this.perEnvironmentData = perEnvironmentData;
    }

    static ClientContextImpl fromConfig(LDConfig config, String mobileKey, String environmentName, PersistentDataStoreWrapper.PerEnvironmentData perEnvironmentData, FeatureFetcher fetcher, LDContext initialContext, LDLogger logger, PlatformState platformState, IEnvironmentReporter environmentReporter, TaskExecutor taskExecutor) {
        boolean initiallyInBackground = platformState != null && !platformState.isForeground();
        ClientContext minimalContext = new ClientContext(mobileKey, environmentReporter, logger, config, null, environmentName, config.isEvaluationReasons(), initialContext, null, initiallyInBackground, null, config.serviceEndpoints, config.isOffline());
        HttpConfiguration httpConfig = config.http.build(minimalContext);
        ClientContext baseClientContext = new ClientContext(mobileKey, environmentReporter, logger, config, null, environmentName, config.isEvaluationReasons(), initialContext, httpConfig, initiallyInBackground, null, config.serviceEndpoints, config.isOffline());
        DiagnosticStore diagnosticStore = null;
        if (!config.getDiagnosticOptOut()) {
            diagnosticStore = new DiagnosticStore(EventUtil.makeDiagnosticParams(baseClientContext));
        }
        return new ClientContextImpl(baseClientContext, diagnosticStore, fetcher, platformState, taskExecutor, perEnvironmentData);
    }

    public static ClientContextImpl get(ClientContext context) {
        if (context instanceof ClientContextImpl) {
            return (ClientContextImpl)context;
        }
        return new ClientContextImpl(context, null, null, null, null, null);
    }

    public static ClientContextImpl forDataSource(ClientContext baseClientContext, DataSourceUpdateSink dataSourceUpdateSink, LDContext newEvaluationContext, boolean newInBackground, Boolean previouslyInBackground) {
        ClientContextImpl baseContextImpl = ClientContextImpl.get(baseClientContext);
        return new ClientContextImpl(new ClientContext(baseClientContext.getMobileKey(), baseClientContext.getEnvironmentReporter(), baseClientContext.getBaseLogger(), baseClientContext.getConfig(), dataSourceUpdateSink, baseClientContext.getEnvironmentName(), baseClientContext.isEvaluationReasons(), newEvaluationContext, baseClientContext.getHttp(), newInBackground, previouslyInBackground, baseClientContext.getServiceEndpoints(), false), baseContextImpl.getDiagnosticStore(), baseContextImpl.getFetcher(), baseContextImpl.getPlatformState(), baseContextImpl.getTaskExecutor(), baseContextImpl.getPerEnvironmentData());
    }

    @Override
    public ClientContextImpl setEvaluationContext(LDContext context) {
        return new ClientContextImpl(super.setEvaluationContext(context), this.diagnosticStore, this.fetcher, this.platformState, this.taskExecutor, this.perEnvironmentData);
    }

    public DiagnosticStore getDiagnosticStore() {
        return this.diagnosticStore;
    }

    public FeatureFetcher getFetcher() {
        return this.fetcher;
    }

    public PlatformState getPlatformState() {
        return ClientContextImpl.throwExceptionIfNull(this.platformState);
    }

    public TaskExecutor getTaskExecutor() {
        return ClientContextImpl.throwExceptionIfNull(this.taskExecutor);
    }

    public PersistentDataStoreWrapper.PerEnvironmentData getPerEnvironmentData() {
        return ClientContextImpl.throwExceptionIfNull(this.perEnvironmentData);
    }

    private static <T> T throwExceptionIfNull(T o) {
        if (o == null) {
            throw new IllegalStateException("Attempted to use an SDK component without the necessary dependencies from LDClient;  this should never happen unless an application has tried to construct the component directly outside of normal SDK usage");
        }
        return o;
    }
}

