/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.android.integrations.EvaluationSeriesContext;
import com.launchdarkly.sdk.android.integrations.Hook;
import com.launchdarkly.sdk.android.integrations.IdentifySeriesContext;
import com.launchdarkly.sdk.android.integrations.IdentifySeriesResult;
import com.launchdarkly.sdk.android.integrations.TrackSeriesContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HookRunner {
    private static final String UNKNOWN_HOOK_NAME = "unknown hook";
    private final LDLogger logger;
    private final List<Hook> hooks = new ArrayList<Hook>();

    public HookRunner(LDLogger logger, List<Hook> initialHooks) {
        this.logger = logger;
        this.hooks.addAll(initialHooks);
    }

    private String getHookName(Hook hook) {
        try {
            String name = hook.getMetadata().getName();
            return name == null || name.isEmpty() ? UNKNOWN_HOOK_NAME : name;
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception thrown getting metadata for hook. Unable to get hook name.");
            return UNKNOWN_HOOK_NAME;
        }
    }

    public void addHook(Hook hook) {
        this.hooks.add(hook);
    }

    public EvaluationDetail<LDValue> withEvaluation(String method, String key, LDContext context, LDValue defaultValue, EvaluationMethod evalMethod) {
        if (this.hooks.isEmpty()) {
            return evalMethod.evaluate();
        }
        ArrayList seriesDataList = new ArrayList(this.hooks.size());
        EvaluationSeriesContext seriesContext = new EvaluationSeriesContext(method, key, context, defaultValue);
        for (int i = 0; i < this.hooks.size(); ++i) {
            Hook currentHook = this.hooks.get(i);
            try {
                Map<String, Object> seriesData = currentHook.beforeEvaluation(seriesContext, Collections.unmodifiableMap(Collections.emptyMap()));
                seriesDataList.add(Collections.unmodifiableMap(seriesData));
                continue;
            }
            catch (Exception e) {
                seriesDataList.add(Collections.unmodifiableMap(Collections.emptyMap()));
                this.logger.error("During evaluation of flag \"{}\". Stage \"beforeEvaluation\" of hook \"{}\" reported error: {}", new Object[]{key, this.getHookName(currentHook), e.toString()});
            }
        }
        EvaluationDetail<LDValue> result = evalMethod.evaluate();
        for (int i = this.hooks.size() - 1; i >= 0; --i) {
            Hook currentHook = this.hooks.get(i);
            try {
                currentHook.afterEvaluation(seriesContext, (Map)seriesDataList.get(i), result);
                continue;
            }
            catch (Exception e) {
                this.logger.error("During evaluation of flag \"{}\". Stage \"afterEvaluation\" of hook \"{}\" reported error: {}", new Object[]{key, this.getHookName(currentHook), e.toString()});
            }
        }
        return result;
    }

    public AfterIdentifyMethod identify(LDContext context, Integer timeout) {
        if (this.hooks.isEmpty()) {
            return result -> {};
        }
        ArrayList seriesDataList = new ArrayList(this.hooks.size());
        IdentifySeriesContext seriesContext = new IdentifySeriesContext(context, timeout);
        for (int i = 0; i < this.hooks.size(); ++i) {
            Hook currentHook = this.hooks.get(i);
            try {
                Map<String, Object> seriesData = currentHook.beforeIdentify(seriesContext, Collections.unmodifiableMap(Collections.emptyMap()));
                seriesDataList.add(Collections.unmodifiableMap(seriesData));
                continue;
            }
            catch (Exception e) {
                seriesDataList.add(Collections.unmodifiableMap(Collections.emptyMap()));
                this.logger.error("During identify with context \"{}\". Stage \"beforeIdentify\" of hook \"{}\" reported error: {}", new Object[]{context.getKey(), this.getHookName(currentHook), e.toString()});
            }
        }
        return result -> {
            for (int i = this.hooks.size() - 1; i >= 0; --i) {
                Hook currentHook = this.hooks.get(i);
                try {
                    currentHook.afterIdentify(seriesContext, (Map)seriesDataList.get(i), result);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("During identify with context \"{}\". Stage \"afterIdentify\" of hook \"{}\" reported error: {}", new Object[]{context.getKey(), this.getHookName(currentHook), e.toString()});
                }
            }
        };
    }

    public void afterTrack(String key, LDContext context, LDValue data, Double metricValue) {
        if (this.hooks.isEmpty()) {
            return;
        }
        TrackSeriesContext seriesContext = new TrackSeriesContext(key, context, data, metricValue);
        for (int i = this.hooks.size() - 1; i >= 0; --i) {
            Hook currentHook = this.hooks.get(i);
            try {
                currentHook.afterTrack(seriesContext);
                continue;
            }
            catch (Exception e) {
                this.logger.error("During tracking of event \"{}\". Stage \"afterTrack\" of hook \"{}\" reported error: {}", new Object[]{key, this.getHookName(currentHook), e.toString()});
            }
        }
    }

    @FunctionalInterface
    public static interface EvaluationMethod {
        public EvaluationDetail<LDValue> evaluate();
    }

    @FunctionalInterface
    public static interface AfterIdentifyMethod {
        public void invoke(IdentifySeriesResult var1);
    }
}

