/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.ConnectivityManager;
import com.launchdarkly.sdk.android.FeatureFetcher;
import com.launchdarkly.sdk.android.PlatformState;
import com.launchdarkly.sdk.android.TaskExecutor;
import com.launchdarkly.sdk.android.subsystems.Callback;
import com.launchdarkly.sdk.android.subsystems.DataSource;
import com.launchdarkly.sdk.android.subsystems.DataSourceUpdateSink;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;

final class PollingDataSource
implements DataSource {
    private final LDContext context;
    private final DataSourceUpdateSink dataSourceUpdateSink;
    final long initialDelayMillis;
    final long pollIntervalMillis;
    long numberOfPollsRemaining;
    private final FeatureFetcher fetcher;
    private final PlatformState platformState;
    private final TaskExecutor taskExecutor;
    private final LDLogger logger;
    final AtomicReference<ScheduledFuture<?>> currentPollTask = new AtomicReference();

    PollingDataSource(LDContext context, DataSourceUpdateSink dataSourceUpdateSink, long initialDelayMillis, long pollIntervalMillis, long maxNumberOfPolls, FeatureFetcher fetcher, PlatformState platformState, TaskExecutor taskExecutor, LDLogger logger) {
        this.context = context;
        this.dataSourceUpdateSink = dataSourceUpdateSink;
        this.initialDelayMillis = initialDelayMillis;
        this.pollIntervalMillis = pollIntervalMillis;
        this.numberOfPollsRemaining = maxNumberOfPolls;
        this.fetcher = fetcher;
        this.platformState = platformState;
        this.taskExecutor = taskExecutor;
        this.logger = logger;
    }

    @Override
    public void start(Callback<Boolean> resultCallback) {
        if (this.numberOfPollsRemaining <= 0L) {
            resultCallback.onSuccess(true);
            return;
        }
        Runnable pollRunnable = () -> this.poll(resultCallback);
        this.logger.debug("Scheduling polling task with interval of {}ms, starting after {}ms, with number of polls {}", new Object[]{this.pollIntervalMillis, this.initialDelayMillis, this.numberOfPollsRemaining});
        ScheduledFuture<?> task = this.taskExecutor.startRepeatingTask(pollRunnable, this.initialDelayMillis, this.pollIntervalMillis);
        this.currentPollTask.set(task);
    }

    @Override
    public void stop(Callback<Void> completionCallback) {
        ScheduledFuture task = this.currentPollTask.getAndSet(null);
        if (task != null) {
            task.cancel(true);
        }
        completionCallback.onSuccess(null);
    }

    private void poll(Callback<Boolean> resultCallback) {
        if (this.numberOfPollsRemaining > 0L) {
            --this.numberOfPollsRemaining;
            ConnectivityManager.fetchAndSetData(this.fetcher, this.context, this.dataSourceUpdateSink, resultCallback, this.logger);
        } else {
            ScheduledFuture task = this.currentPollTask.getAndSet(null);
            if (task != null) {
                task.cancel(true);
            }
        }
    }
}

