/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.Variation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;

class FeatureRep<E> {
    String name;
    String key;
    String salt;
    boolean on;
    List<Variation<E>> variations;
    private static final float long_scale = 1.1529215E18f;

    public FeatureRep() {
    }

    FeatureRep(Builder<E> b) {
        this.name = ((Builder)b).name;
        this.key = ((Builder)b).key;
        this.salt = ((Builder)b).salt;
        this.on = ((Builder)b).on;
        this.variations = new ArrayList<Variation<E>>(((Builder)b).variations);
    }

    private Float paramForUser(LDUser user) {
        if (user.getKey() == null) {
            return null;
        }
        String idHash = user.getKey();
        if (user.getSecondary() != null) {
            idHash = idHash + "." + user.getSecondary();
        }
        String hash = DigestUtils.shaHex((String)(this.key + "." + this.salt + "." + idHash)).substring(0, 15);
        long longVal = Long.parseLong(hash, 16);
        float result = (float)longVal / 1.1529215E18f;
        System.out.println("Parameter value: " + result);
        return Float.valueOf(result);
    }

    public E evaluate(LDUser user) {
        if (!this.on || user == null) {
            return null;
        }
        Float param = this.paramForUser(user);
        if (param == null) {
            return null;
        }
        for (Variation<E> variation : this.variations) {
            if (!variation.matchTarget(user)) continue;
            return variation.value;
        }
        float sum = 0.0f;
        for (Variation<E> variation : this.variations) {
            sum = (float)((double)sum + (double)variation.weight / 100.0);
            if (!(param.floatValue() < sum)) continue;
            return variation.value;
        }
        return null;
    }

    static class Builder<E> {
        private String name;
        private String key;
        private boolean on = true;
        private String salt;
        private List<Variation<E>> variations;

        Builder(String name, String key) {
            this.name = name;
            this.key = key;
            this.salt = UUID.randomUUID().toString();
            this.variations = new ArrayList<Variation<E>>();
        }

        Builder<E> salt(String s) {
            this.salt = s;
            return this;
        }

        Builder<E> on(boolean b) {
            this.on = b;
            return this;
        }

        Builder<E> variation(Variation<E> v) {
            this.variations.add(v);
            return this;
        }

        FeatureRep<E> build() {
            return new FeatureRep(this);
        }
    }
}

