/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.http.HttpEntity;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LDClient {
    private final Logger logger = LoggerFactory.getLogger(LDClient.class);
    private final LDConfig config;
    private final CloseableHttpClient client;

    public LDClient(String apiKey) {
        this(new LDConfig(apiKey));
    }

    public LDClient(LDConfig config) {
        this.config = config;
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(100);
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(8192L).setSharedCache(false).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(3000).build();
        this.client = CachingHttpClients.custom().setCacheConfig(cacheConfig).setDefaultRequestConfig(requestConfig).build();
    }

    private HttpGet getRequest(String path) {
        URIBuilder builder = this.config.getBuilder().setPath(path);
        try {
            HttpGet request = new HttpGet(builder.build());
            request.addHeader("Authorization", "api_key " + this.config.apiKey);
            request.addHeader("User-Agent", "JavaClient/" + LDClient.getClientVersion());
            return request;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFlag(String key, LDUser user, boolean defaultValue) {
        Gson gson = new Gson();
        HttpCacheContext context = HttpCacheContext.create();
        HttpGet request = this.getRequest("/api/eval/features/" + key);
        CloseableHttpResponse response = null;
        try {
            int status;
            response = this.client.execute((HttpUriRequest)request, (HttpContext)context);
            CacheResponseStatus responseStatus = context.getCacheResponseStatus();
            if (this.logger.isDebugEnabled()) {
                switch (responseStatus) {
                    case CACHE_HIT: {
                        this.logger.debug("A response was generated from the cache with no requests sent upstream");
                        break;
                    }
                    case CACHE_MODULE_RESPONSE: {
                        this.logger.debug("The response was generated directly by the caching module");
                        break;
                    }
                    case CACHE_MISS: {
                        this.logger.debug("The response came from an upstream server");
                        break;
                    }
                    case VALIDATED: {
                        this.logger.debug("The response was generated from the cache after validating the entry with the origin server");
                        break;
                    }
                }
            }
            if ((status = response.getStatusLine().getStatusCode()) != 200) {
                if (status == 401) {
                    this.logger.info("Invalid API key");
                } else if (status == 404) {
                    this.logger.error("Unknown feature key: " + key);
                } else {
                    this.logger.error("Unexpected status code: " + status);
                }
                boolean bl = defaultValue;
                return bl;
            }
            Type boolType = new TypeToken<FeatureRep<Boolean>>(){}.getType();
            FeatureRep result = (FeatureRep)gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), boolType);
            Boolean val = (Boolean)result.evaluate(user);
            if (val == null) {
                boolean bl = defaultValue;
                return bl;
            }
            boolean bl = val;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = defaultValue;
            return bl;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static String getClientVersion() {
        Class<LDClient> clazz = LDClient.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return "Unknown";
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        Manifest manifest = null;
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Implementation-Version");
            return value;
        }
        catch (IOException e) {
            return "Unknown";
        }
    }
}

