/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LDUser {
    private String key;
    private String secondary;
    private String ip;
    private String country;
    private Map<String, JsonElement> custom;

    public LDUser() {
    }

    public LDUser(Builder builder) {
        this.key = builder.key;
        this.ip = builder.ip;
        this.country = builder.country;
        this.secondary = builder.secondary;
        this.custom = new HashMap<String, JsonElement>(builder.custom);
    }

    public LDUser(String key) {
        this.key = key;
    }

    String getKey() {
        return this.key;
    }

    String getIp() {
        return this.ip;
    }

    String getCountry() {
        return this.country;
    }

    String getSecondary() {
        return this.secondary;
    }

    JsonElement getCustom(String key) {
        return this.custom.get(key);
    }

    public static class Builder {
        private String key;
        private String secondary;
        private String ip;
        private String country;
        private Map<String, JsonElement> custom;

        public Builder(String key) {
            this.key = key;
            this.custom = new HashMap<String, JsonElement>();
        }

        public Builder ip(String s) {
            this.ip = s;
            return this;
        }

        public Builder secondary(String s) {
            this.secondary = s;
            return this;
        }

        public Builder country(String s) {
            this.country = s;
            return this;
        }

        public Builder custom(String k, String v) {
            this.custom.put(k, (JsonElement)new JsonPrimitive(v));
            return this;
        }

        public Builder custom(String k, Number n) {
            this.custom.put(k, (JsonElement)new JsonPrimitive(n));
            return this;
        }

        public Builder custom(String k, List<String> vs) {
            JsonArray array = new JsonArray();
            for (String v : vs) {
                array.add((JsonElement)new JsonPrimitive(v));
            }
            this.custom.put(k, (JsonElement)array);
            return this;
        }

        public LDUser build() {
            return new LDUser(this);
        }
    }
}

