/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.launchdarkly.client.LDUser;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Variation<E> {
    E value;
    int weight;
    List<TargetRule> targets;
    private final Logger logger = LoggerFactory.getLogger(Variation.class);

    public Variation() {
    }

    Variation(Builder<E> b) {
        this.value = b.value;
        this.weight = b.weight;
        this.targets = new ArrayList<TargetRule>(b.targets);
    }

    public boolean matchTarget(LDUser user) {
        for (TargetRule target : this.targets) {
            if (!target.matchTarget(user)) continue;
            return true;
        }
        return false;
    }

    static class TargetRule {
        String attribute;
        String operator;
        List<String> values;
        private final Logger logger = LoggerFactory.getLogger(TargetRule.class);

        TargetRule(String attribute, String operator, List<String> values) {
            this.attribute = attribute;
            this.operator = operator;
            this.values = new ArrayList<String>(values);
        }

        TargetRule(String attribute, List<String> values) {
            this(attribute, "in", values);
        }

        public boolean matchTarget(LDUser user) {
            String uValue = null;
            if (this.attribute.equals("key")) {
                if (user.getKey() != null) {
                    uValue = user.getKey();
                }
            } else if (this.attribute.equals("ip") && user.getIp() != null) {
                if (user.getIp() != null) {
                    uValue = user.getIp();
                }
            } else if (this.attribute.equals("country")) {
                if (user.getCountry() != null) {
                    uValue = user.getCountry();
                }
            } else {
                JsonElement custom = user.getCustom(this.attribute);
                if (custom != null) {
                    if (custom.isJsonArray()) {
                        JsonArray array = custom.getAsJsonArray();
                        for (JsonElement elt : array) {
                            if (!elt.isJsonPrimitive()) {
                                this.logger.error("Invalid custom attribute value in user object: " + elt);
                                return false;
                            }
                            if (!this.values.contains(elt.getAsString())) continue;
                            return true;
                        }
                        return false;
                    }
                    if (custom.isJsonPrimitive()) {
                        return this.values.contains(custom.getAsString());
                    }
                }
                return false;
            }
            if (uValue == null) {
                return false;
            }
            return this.values.contains(uValue);
        }
    }

    static class Builder<E> {
        E value;
        int weight;
        List<TargetRule> targets;

        Builder(E value, int weight) {
            this.value = value;
            this.weight = weight;
            this.targets = new ArrayList<TargetRule>();
        }

        Builder<E> target(TargetRule rule) {
            this.targets.add(rule);
            return this;
        }

        Variation<E> build() {
            return new Variation(this);
        }
    }
}

