/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.Variation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;

class FeatureRep<E> {
    String name;
    String key;
    String salt;
    boolean on;
    List<Variation<E>> variations;
    boolean deleted;
    int version;
    private static final float long_scale = 1.1529215E18f;

    public FeatureRep() {
    }

    public String toString() {
        return "FeatureRep{name='" + this.name + '\'' + ", key='" + this.key + '\'' + ", salt='" + this.salt + '\'' + ", on=" + this.on + ", variations=" + this.variations + ", deleted=" + this.deleted + ", version=" + this.version + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureRep that = (FeatureRep)o;
        if (this.on != that.on) {
            return false;
        }
        if (this.deleted != that.deleted) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        if (!this.salt.equals(that.salt)) {
            return false;
        }
        return this.variations.equals(that.variations);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.salt.hashCode();
        result = 31 * result + (this.on ? 1 : 0);
        result = 31 * result + this.variations.hashCode();
        result = 31 * result + (this.deleted ? 1 : 0);
        result = 31 * result + this.version;
        return result;
    }

    FeatureRep(Builder<E> b) {
        this.name = ((Builder)b).name;
        this.key = ((Builder)b).key;
        this.salt = ((Builder)b).salt;
        this.on = ((Builder)b).on;
        this.deleted = ((Builder)b).deleted;
        this.version = ((Builder)b).version;
        this.variations = new ArrayList<Variation<E>>(((Builder)b).variations);
    }

    private Float paramForUser(LDUser user) {
        if (user.getKey() == null) {
            return null;
        }
        String idHash = user.getKey();
        if (user.getSecondary() != null) {
            idHash = idHash + "." + user.getSecondary();
        }
        String hash = DigestUtils.shaHex((String)(this.key + "." + this.salt + "." + idHash)).substring(0, 15);
        long longVal = Long.parseLong(hash, 16);
        float result = (float)longVal / 1.1529215E18f;
        return Float.valueOf(result);
    }

    public E evaluate(LDUser user) {
        if (!this.on || user == null) {
            return null;
        }
        Float param = this.paramForUser(user);
        if (param == null) {
            return null;
        }
        for (Variation<E> variation : this.variations) {
            if (!variation.matchUser(user)) continue;
            return variation.value;
        }
        for (Variation<E> variation : this.variations) {
            if (!variation.matchTarget(user)) continue;
            return variation.value;
        }
        float sum = 0.0f;
        for (Variation<E> variation : this.variations) {
            sum = (float)((double)sum + (double)variation.weight / 100.0);
            if (!(param.floatValue() < sum)) continue;
            return variation.value;
        }
        return null;
    }

    static class Builder<E> {
        private String name;
        private String key;
        private boolean on = true;
        private String salt;
        private boolean deleted;
        private int version;
        private List<Variation<E>> variations;

        Builder(String name, String key) {
            this.name = name;
            this.key = key;
            this.salt = UUID.randomUUID().toString();
            this.variations = new ArrayList<Variation<E>>();
        }

        Builder<E> salt(String s) {
            this.salt = s;
            return this;
        }

        Builder<E> on(boolean b) {
            this.on = b;
            return this;
        }

        Builder<E> variation(Variation<E> v) {
            this.variations.add(v);
            return this;
        }

        Builder<E> deleted(boolean d) {
            this.deleted = d;
            return this;
        }

        Builder<E> version(int v) {
            this.version = v;
            return this;
        }

        FeatureRep<E> build() {
            return new FeatureRep(this);
        }
    }
}

