/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.launchdarkly.client.CustomEvent;
import com.launchdarkly.client.EventProcessor;
import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.FeatureRequestEvent;
import com.launchdarkly.client.FeatureRequestor;
import com.launchdarkly.client.IdentifyEvent;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.NewRelicReflector;
import com.launchdarkly.client.StreamProcessor;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.http.annotation.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LDClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(LDClient.class);
    private final LDConfig config;
    private final FeatureRequestor requestor;
    private final EventProcessor eventProcessor;
    private final StreamProcessor streamProcessor;
    protected static final String CLIENT_VERSION = LDClient.getClientVersion();
    private volatile boolean offline = false;

    public LDClient(String apiKey) {
        this(apiKey, LDConfig.DEFAULT);
    }

    public LDClient(String apiKey, LDConfig config) {
        this.config = config;
        this.requestor = this.createFeatureRequestor(apiKey, config);
        this.eventProcessor = this.createEventProcessor(apiKey, config);
        if (config.stream) {
            logger.debug("Enabling streaming API");
            this.streamProcessor = this.createStreamProcessor(apiKey, config, this.requestor);
            this.streamProcessor.subscribe();
        } else {
            logger.debug("Streaming API disabled");
            this.streamProcessor = null;
        }
    }

    protected FeatureRequestor createFeatureRequestor(String apiKey, LDConfig config) {
        return new FeatureRequestor(apiKey, config);
    }

    protected EventProcessor createEventProcessor(String apiKey, LDConfig config) {
        return new EventProcessor(apiKey, config);
    }

    protected StreamProcessor createStreamProcessor(String apiKey, LDConfig config, FeatureRequestor requestor) {
        return new StreamProcessor(apiKey, config, requestor);
    }

    public void track(String eventName, LDUser user, JsonElement data) {
        boolean processed = this.eventProcessor.sendEvent(new CustomEvent(eventName, user, data));
        if (!processed) {
            logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
        }
    }

    public void track(String eventName, LDUser user) {
        if (this.offline) {
            return;
        }
        this.track(eventName, user, null);
    }

    public void identify(LDUser user) {
        if (this.offline) {
            return;
        }
        boolean processed = this.eventProcessor.sendEvent(new IdentifyEvent(user));
        if (!processed) {
            logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
        }
    }

    private void sendFlagRequestEvent(String featureKey, LDUser user, boolean value) {
        boolean processed = this.eventProcessor.sendEvent(new FeatureRequestEvent<Boolean>(featureKey, user, value));
        if (!processed) {
            logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
        }
        NewRelicReflector.annotateTransaction(featureKey, String.valueOf(value));
    }

    public boolean getFlag(String featureKey, LDUser user, boolean defaultValue) {
        return this.toggle(featureKey, user, defaultValue);
    }

    public boolean toggle(String featureKey, LDUser user, boolean defaultValue) {
        if (this.offline) {
            return defaultValue;
        }
        try {
            FeatureRep<Object> result;
            if (this.config.stream && this.streamProcessor != null && this.streamProcessor.initialized()) {
                FeatureRep pollingResult;
                logger.debug("Using feature flag stored from streaming API");
                result = this.streamProcessor.getFeature(featureKey);
                if (this.config.debugStreaming && !result.equals(pollingResult = this.requestor.makeRequest(featureKey, true))) {
                    logger.warn("Mismatch between streaming and polling feature! Streaming: {} Polling: {}", result, pollingResult);
                }
            } else {
                result = this.requestor.makeRequest(featureKey, this.config.stream);
            }
            if (result == null) {
                logger.warn("Unknown feature flag " + featureKey + "; returning default value");
                this.sendFlagRequestEvent(featureKey, user, defaultValue);
                return defaultValue;
            }
            Boolean val = (Boolean)result.evaluate(user);
            if (val == null) {
                this.sendFlagRequestEvent(featureKey, user, defaultValue);
                return defaultValue;
            }
            boolean value = val;
            this.sendFlagRequestEvent(featureKey, user, value);
            return value;
        }
        catch (Exception e) {
            logger.error("Encountered exception in LaunchDarkly client", (Throwable)e);
            this.sendFlagRequestEvent(featureKey, user, defaultValue);
            return defaultValue;
        }
    }

    @Override
    public void close() throws IOException {
        this.eventProcessor.close();
        if (this.streamProcessor != null) {
            this.streamProcessor.close();
        }
    }

    public void flush() {
        this.eventProcessor.flush();
    }

    public void setOffline() {
        this.offline = true;
    }

    public void setOnline() {
        this.offline = false;
    }

    public boolean isOffline() {
        return this.offline;
    }

    private static String getClientVersion() {
        Class<LDConfig> clazz = LDConfig.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return "Unknown";
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        Manifest manifest = null;
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Implementation-Version");
            return value;
        }
        catch (IOException e) {
            logger.warn("Unable to determine LaunchDarkly client library version", (Throwable)e);
            return "Unknown";
        }
    }
}

