/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.EventSource;
import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.FeatureRequestor;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.LDConfig;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamProcessor
implements Closeable {
    private static final String PUT = "put";
    private static final String PATCH = "patch";
    private static final String DELETE = "delete";
    private static final String INDIRECT_PUT = "indirect/put";
    private static final String INDIRECT_PATCH = "indirect/patch";
    private static final Logger logger = LoggerFactory.getLogger(StreamProcessor.class);
    private final Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(SseFeature.class)).build();
    private final FeatureStore store;
    private final LDConfig config;
    private final String apiKey;
    private final FeatureRequestor requestor;
    private EventSource es;

    StreamProcessor(String apiKey, LDConfig config, FeatureRequestor requestor) {
        this.store = config.featureStore;
        this.config = config;
        this.apiKey = apiKey;
        this.requestor = requestor;
    }

    void subscribe() {
        if (this.config.useLdd) {
            return;
        }
        StringKeyIgnoreCaseMultivaluedMap headers = new StringKeyIgnoreCaseMultivaluedMap();
        headers.putSingle((Object)"Authorization", (Object)("api_key " + this.apiKey));
        headers.putSingle((Object)"User-Agent", (Object)("JavaClient/" + LDClient.CLIENT_VERSION));
        headers.putSingle((Object)"Accept", (Object)SseFeature.SERVER_SENT_EVENTS_TYPE);
        WebTarget target = this.client.target(this.config.streamURI.toASCIIString() + "/features");
        this.es = new EventSource(target, true, (MultivaluedMap)headers){

            @Override
            public void onEvent(InboundEvent event) {
                Gson gson = new Gson();
                if (event.getName().equals(StreamProcessor.PUT)) {
                    Type type = new TypeToken<Map<String, FeatureRep<?>>>(){}.getType();
                    Map features = (Map)gson.fromJson(event.readData(), type);
                    StreamProcessor.this.store.init(features);
                } else if (event.getName().equals(StreamProcessor.PATCH)) {
                    FeaturePatchData data = (FeaturePatchData)gson.fromJson(event.readData(), FeaturePatchData.class);
                    StreamProcessor.this.store.upsert(data.key(), data.feature());
                } else if (event.getName().equals(StreamProcessor.DELETE)) {
                    FeatureDeleteData data = (FeatureDeleteData)gson.fromJson(event.readData(), FeatureDeleteData.class);
                    StreamProcessor.this.store.delete(data.key(), data.version());
                } else if (event.getName().equals(StreamProcessor.INDIRECT_PUT)) {
                    try {
                        Map<String, FeatureRep<?>> features = StreamProcessor.this.requestor.makeAllRequest(true);
                        StreamProcessor.this.store.init(features);
                    }
                    catch (IOException e) {
                        logger.error("Encountered exception in LaunchDarkly client", (Throwable)e);
                    }
                } else if (event.getName().equals(StreamProcessor.INDIRECT_PATCH)) {
                    String key = event.readData();
                    try {
                        FeatureRep feature = StreamProcessor.this.requestor.makeRequest(key, true);
                        StreamProcessor.this.store.upsert(key, feature);
                    }
                    catch (IOException e) {
                        logger.error("Encountered exception in LaunchDarkly client", (Throwable)e);
                    }
                } else {
                    logger.warn("Unexpected event found in stream: " + event.getName());
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.es != null) {
            this.es.close();
        }
    }

    boolean initialized() {
        return this.store.initialized();
    }

    FeatureRep<?> getFeature(String key) {
        return this.store.get(key);
    }

    private static final class FeatureDeleteData {
        String path;
        int version;

        String key() {
            return this.path.substring(1);
        }

        int version() {
            return this.version;
        }
    }

    private static final class FeaturePatchData {
        String path;
        FeatureRep<?> data;

        String key() {
            return this.path.substring(1);
        }

        FeatureRep<?> feature() {
            return this.data;
        }
    }
}

