/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.FeatureStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class InMemoryFeatureStore
implements FeatureStore {
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final Map<String, FeatureRep<?>> features = new HashMap();
    volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureRep<?> get(String key) {
        try {
            this.lock.readLock().lock();
            FeatureRep<?> rep = this.features.get(key);
            if (rep == null || rep.deleted) {
                FeatureRep<?> featureRep = null;
                return featureRep;
            }
            FeatureRep<?> featureRep = rep;
            return featureRep;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, FeatureRep<?>> all() {
        try {
            this.lock.readLock().lock();
            HashMap fs = new HashMap();
            for (Map.Entry<String, FeatureRep<?>> entry : this.features.entrySet()) {
                if (entry.getValue().deleted) continue;
                fs.put(entry.getKey(), entry.getValue());
            }
            HashMap<String, FeatureRep<?>> hashMap = fs;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void init(Map<String, FeatureRep<?>> features) {
        try {
            this.lock.writeLock().lock();
            this.features.clear();
            this.features.putAll(features);
            this.initialized = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key, int version) {
        try {
            this.lock.writeLock().lock();
            FeatureRep<Object> f = this.features.get(key);
            if (f != null && f.version < version) {
                f.deleted = true;
                f.version = version;
                this.features.put(key, f);
            } else if (f == null) {
                f = new FeatureRep.Builder(key, key).deleted(true).version(version).build();
                this.features.put(key, f);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsert(String key, FeatureRep<?> feature) {
        try {
            this.lock.writeLock().lock();
            FeatureRep<?> old = this.features.get(key);
            if (old == null || old.version < feature.version) {
                this.features.put(key, feature);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }
}

