/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.FeatureStore;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;

public class RedisFeatureStore
implements FeatureStore {
    private static final String DEFAULT_PREFIX = "launchdarkly";
    private final Jedis jedis;
    private LoadingCache<String, FeatureRep<?>> cache;
    private LoadingCache<String, Boolean> initCache;
    private String prefix;
    private static final String INIT_KEY = "$initialized$";

    public RedisFeatureStore(String host, int port, String prefix, long cacheTimeSecs) {
        this.jedis = new Jedis(host, port);
        this.setPrefix(prefix);
        this.createCache(cacheTimeSecs);
        this.createInitCache(cacheTimeSecs);
    }

    public RedisFeatureStore(URI uri, String prefix, long cacheTimeSecs) {
        this.jedis = new Jedis(uri);
        this.setPrefix(prefix);
        this.createCache(cacheTimeSecs);
        this.createInitCache(cacheTimeSecs);
    }

    public RedisFeatureStore() {
        this.jedis = new Jedis("localhost");
        this.prefix = DEFAULT_PREFIX;
    }

    private void setPrefix(String prefix) {
        this.prefix = prefix == null || prefix.isEmpty() ? DEFAULT_PREFIX : prefix;
    }

    private void createCache(long cacheTimeSecs) {
        if (cacheTimeSecs > 0L) {
            this.cache = CacheBuilder.newBuilder().expireAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build(new CacheLoader<String, FeatureRep<?>>(){

                public FeatureRep<?> load(String key) throws Exception {
                    return RedisFeatureStore.this.getRedis(key);
                }
            });
        }
    }

    private void createInitCache(long cacheTimeSecs) {
        if (cacheTimeSecs > 0L) {
            this.initCache = CacheBuilder.newBuilder().expireAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Boolean>(){

                public Boolean load(String key) throws Exception {
                    return RedisFeatureStore.this.getInit();
                }
            });
        }
    }

    @Override
    public FeatureRep<?> get(String key) {
        if (this.cache != null) {
            return (FeatureRep)this.cache.getUnchecked((Object)key);
        }
        return this.getRedis(key);
    }

    @Override
    public Map<String, FeatureRep<?>> all() {
        Map featuresJson = this.jedis.hgetAll(this.featuresKey());
        HashMap result = new HashMap();
        Gson gson = new Gson();
        Type type = new TypeToken<FeatureRep<?>>(){}.getType();
        for (Map.Entry entry : featuresJson.entrySet()) {
            FeatureRep rep = (FeatureRep)gson.fromJson((String)entry.getValue(), type);
            result.put((String)entry.getKey(), rep);
        }
        return result;
    }

    @Override
    public void init(Map<String, FeatureRep<?>> features) {
        Gson gson = new Gson();
        Transaction t = this.jedis.multi();
        t.del(this.featuresKey());
        for (FeatureRep<?> f : features.values()) {
            t.hset(this.featuresKey(), f.key, gson.toJson(f));
        }
        t.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key, int version) {
        try {
            Gson gson = new Gson();
            this.jedis.watch(new String[]{this.featuresKey()});
            FeatureRep<?> feature = this.getRedis(key);
            if (feature != null && feature.version >= version) {
                return;
            }
            feature.deleted = true;
            feature.version = version;
            this.jedis.hset(this.featuresKey(), key, gson.toJson(feature));
            if (this.cache != null) {
                this.cache.invalidate((Object)key);
            }
        }
        finally {
            this.jedis.unwatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsert(String key, FeatureRep<?> feature) {
        try {
            Gson gson = new Gson();
            this.jedis.watch(new String[]{this.featuresKey()});
            FeatureRep<?> f = this.getRedis(key);
            if (f != null && f.version >= feature.version) {
                return;
            }
            this.jedis.hset(this.featuresKey(), key, gson.toJson(feature));
            if (this.cache != null) {
                this.cache.invalidate((Object)key);
            }
        }
        finally {
            this.jedis.unwatch();
        }
    }

    @Override
    public boolean initialized() {
        Boolean initialized;
        if (this.initCache != null && (initialized = (Boolean)this.initCache.getUnchecked((Object)INIT_KEY)) != null && initialized.booleanValue()) {
            return true;
        }
        return this.getInit();
    }

    private String featuresKey() {
        return this.prefix + ":features";
    }

    private Boolean getInit() {
        return this.jedis.exists(this.featuresKey());
    }

    private FeatureRep<?> getRedis(String key) {
        Gson gson = new Gson();
        String featureJson = this.jedis.hget(this.featuresKey(), key);
        if (featureJson == null) {
            return null;
        }
        Type type = new TypeToken<FeatureRep<?>>(){}.getType();
        FeatureRep f = (FeatureRep)gson.fromJson(featureJson, type);
        return f.deleted ? null : f;
    }
}

