/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.CustomEvent;
import com.launchdarkly.client.EventProcessor;
import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.FeatureRequestEvent;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.NewRelicReflector;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.http.HttpEntity;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LDClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(LDClient.class);
    private final LDConfig config;
    private final CloseableHttpClient client;
    private final EventProcessor eventProcessor;

    public LDClient(String apiKey) {
        this(new LDConfig(apiKey));
    }

    public LDClient(LDConfig config) {
        this.config = config;
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(100);
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(8192L).setSharedCache(false).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(3000).build();
        this.client = CachingHttpClients.custom().setCacheConfig(cacheConfig).setDefaultRequestConfig(requestConfig).build();
        this.eventProcessor = new EventProcessor(config);
    }

    public void sendEvent(String eventName, LDUser user, JsonObject data) {
        boolean processed = this.eventProcessor.sendEvent(new CustomEvent(eventName, user, data));
        if (!processed) {
            logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
        }
    }

    private void sendFlagRequestEvent(String featureKey, LDUser user, boolean value) {
        boolean processed = this.eventProcessor.sendEvent(new FeatureRequestEvent<Boolean>(featureKey, user, value));
        if (!processed) {
            logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
        }
        NewRelicReflector.annotateTransaction(featureKey, String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFlag(String featureKey, LDUser user, boolean defaultValue) {
        Gson gson = new Gson();
        HttpCacheContext context = HttpCacheContext.create();
        HttpGet request = this.config.getRequest("/api/eval/features/" + featureKey);
        CloseableHttpResponse response = null;
        try {
            int status;
            response = this.client.execute((HttpUriRequest)request, (HttpContext)context);
            CacheResponseStatus responseStatus = context.getCacheResponseStatus();
            if (logger.isDebugEnabled()) {
                switch (responseStatus) {
                    case CACHE_HIT: {
                        logger.debug("A response was generated from the cache with no requests sent upstream");
                        break;
                    }
                    case CACHE_MODULE_RESPONSE: {
                        logger.debug("The response was generated directly by the caching module");
                        break;
                    }
                    case CACHE_MISS: {
                        logger.debug("The response came from an upstream server");
                        break;
                    }
                    case VALIDATED: {
                        logger.debug("The response was generated from the cache after validating the entry with the origin server");
                    }
                }
            }
            if ((status = response.getStatusLine().getStatusCode()) != 200) {
                if (status == 401) {
                    logger.error("Invalid API key");
                } else if (status == 404) {
                    logger.error("Unknown feature key: " + featureKey);
                } else {
                    logger.error("Unexpected status code: " + status);
                }
                this.sendFlagRequestEvent(featureKey, user, defaultValue);
                boolean bl = defaultValue;
                return bl;
            }
            Type boolType = new TypeToken<FeatureRep<Boolean>>(){}.getType();
            FeatureRep result = (FeatureRep)gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), boolType);
            Boolean val = (Boolean)result.evaluate(user);
            if (val == null) {
                this.sendFlagRequestEvent(featureKey, user, defaultValue);
                boolean bl = defaultValue;
                return bl;
            }
            boolean value = val;
            this.sendFlagRequestEvent(featureKey, user, value);
            boolean bl = value;
            return bl;
        }
        catch (IOException e) {
            logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
            this.sendFlagRequestEvent(featureKey, user, defaultValue);
            boolean bl = defaultValue;
            return bl;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.eventProcessor.close();
    }
}

