/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;
import org.glassfish.jersey.media.sse.EventInput;
import org.glassfish.jersey.media.sse.EventListener;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.LocalizationMessages;
import org.glassfish.jersey.media.sse.SseFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSource
implements EventListener {
    public static final long RECONNECT_DEFAULT = 500L;
    private static final Logger logger = LoggerFactory.getLogger(EventSource.class);
    private final WebTarget target;
    private final long reconnectDelay;
    private final boolean disableKeepAlive;
    private final ScheduledExecutorService executor;
    private final AtomicReference<State> state = new AtomicReference<State>(State.READY);
    private final List<EventListener> unboundListeners = new CopyOnWriteArrayList<EventListener>();
    private final ConcurrentMap<String, List<EventListener>> boundListeners = new ConcurrentHashMap<String, List<EventListener>>();
    private final MultivaluedMap<String, Object> headers;

    public static Builder target(WebTarget endpoint) {
        return new Builder(endpoint);
    }

    public EventSource(WebTarget endpoint) {
        this(endpoint, true, (MultivaluedMap<String, Object>)new StringKeyIgnoreCaseMultivaluedMap());
    }

    public EventSource(WebTarget endpoint, boolean open, MultivaluedMap<String, Object> headers) {
        this(endpoint, null, 500L, true, open, headers);
    }

    private EventSource(WebTarget target, String name, long reconnectDelay, boolean disableKeepAlive, boolean open, MultivaluedMap<String, Object> headers) {
        if (target == null) {
            throw new NullPointerException("Web target is 'null'.");
        }
        this.target = target;
        this.reconnectDelay = reconnectDelay;
        this.disableKeepAlive = disableKeepAlive;
        final String esName = name == null ? EventSource.createDefaultName(target) : name;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, esName);
                t.setDaemon(true);
                return t;
            }
        });
        this.headers = new StringKeyIgnoreCaseMultivaluedMap();
        this.headers.putAll(headers);
        if (open) {
            this.open();
        }
    }

    private static String createDefaultName(WebTarget target) {
        return String.format("jersey-sse-event-source-[%s]", target.getUri().toASCIIString());
    }

    public void open() {
        if (!this.state.compareAndSet(State.READY, State.OPEN)) {
            switch (this.state.get()) {
                case OPEN: {
                    throw new IllegalStateException(LocalizationMessages.EVENT_SOURCE_ALREADY_CONNECTED());
                }
                case CLOSED: {
                    throw new IllegalStateException(LocalizationMessages.EVENT_SOURCE_ALREADY_CLOSED());
                }
            }
        }
        EventProcessor processor = new EventProcessor(this.reconnectDelay, null, this.headers);
        this.executor.submit(processor);
    }

    public boolean isOpen() {
        return this.state.get() == State.OPEN;
    }

    public void register(EventListener listener) {
        this.register(listener, null, new String[0]);
    }

    public void register(EventListener listener, String eventName, String ... eventNames) {
        if (eventName == null) {
            this.unboundListeners.add(listener);
        } else {
            this.addBoundListener(eventName, listener);
            if (eventNames != null) {
                for (String name : eventNames) {
                    this.addBoundListener(name, listener);
                }
            }
        }
    }

    private void addBoundListener(String name, EventListener listener) {
        List listeners = this.boundListeners.putIfAbsent(name, new CopyOnWriteArrayList<EventListener>(Collections.singleton(listener)));
        if (listeners != null) {
            listeners.add(listener);
        }
    }

    public void onEvent(InboundEvent inboundEvent) {
    }

    public void close() {
        this.close(5L, TimeUnit.SECONDS);
    }

    public boolean close(long timeout, TimeUnit unit) {
        this.shutdown();
        try {
            if (!this.executor.awaitTermination(timeout, unit)) {
                return false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    private void shutdown() {
        if (this.state.getAndSet(State.CLOSED) != State.CLOSED) {
            this.executor.shutdownNow();
        }
    }

    private class EventProcessor
    implements Runnable,
    EventListener {
        private final CountDownLatch firstContactSignal;
        private final MultivaluedMap<String, Object> headers;
        private String lastEventId;
        private long reconnectDelay;

        public EventProcessor(long reconnectDelay, String lastEventId, MultivaluedMap<String, Object> headers) {
            this.firstContactSignal = new CountDownLatch(1);
            this.reconnectDelay = reconnectDelay;
            this.lastEventId = lastEventId;
            this.headers = headers;
        }

        private EventProcessor(EventProcessor that) {
            this.firstContactSignal = null;
            this.reconnectDelay = that.reconnectDelay;
            this.lastEventId = that.lastEventId;
            this.headers = that.headers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug("Listener task started.");
            EventInput eventInput = null;
            try {
                try {
                    Invocation.Builder request = this.prepareHandshakeRequest();
                    if (EventSource.this.state.get() == State.OPEN) {
                        logger.debug("Connecting...");
                        eventInput = (EventInput)request.get(EventInput.class);
                        logger.debug("Connected!");
                    }
                }
                catch (Exception e) {
                    logger.warn("Encountered error trying to connect", (Throwable)e);
                }
                finally {
                    if (this.firstContactSignal != null) {
                        this.firstContactSignal.countDown();
                    }
                }
                Thread execThread = Thread.currentThread();
                while (EventSource.this.state.get() == State.OPEN && !execThread.isInterrupted()) {
                    if (eventInput == null || eventInput.isClosed()) {
                        logger.debug("Connection lost - scheduling reconnect in {} ms", (Object)this.reconnectDelay);
                        this.scheduleReconnect(this.reconnectDelay);
                        break;
                    }
                    this.onEvent((InboundEvent)eventInput.read());
                }
            }
            catch (ServiceUnavailableException ex) {
                logger.debug("Received HTTP 503");
                long delay = this.reconnectDelay;
                if (ex.hasRetryAfter()) {
                    logger.debug("Recovering from HTTP 503 using HTTP Retry-After header value as a reconnect delay");
                    Date requestTime = new Date();
                    delay = ex.getRetryTime(requestTime).getTime() - requestTime.getTime();
                    delay = delay > 0L ? delay : 0L;
                }
                logger.debug("Recovering from HTTP 503 - scheduling to reconnect in {} ms", (Object)delay);
                this.scheduleReconnect(delay);
            }
            catch (Exception ex) {
                logger.debug("Recovering from exception -- scheduling reconnect in {} ms", (Object)this.reconnectDelay, (Object)ex);
                this.scheduleReconnect(this.reconnectDelay);
            }
            finally {
                if (eventInput != null && !eventInput.isClosed()) {
                    eventInput.close();
                }
                logger.debug("Listener task finished.");
            }
        }

        public void onEvent(InboundEvent event) {
            List eventListeners;
            if (event == null) {
                return;
            }
            logger.debug("New event received.");
            if (event.getId() != null) {
                this.lastEventId = event.getId();
            }
            if (event.isReconnectDelaySet()) {
                this.reconnectDelay = event.getReconnectDelay();
            }
            this.notify(EventSource.this, event);
            this.notify(EventSource.this.unboundListeners, event);
            String eventName = event.getName();
            if (eventName != null && (eventListeners = (List)EventSource.this.boundListeners.get(eventName)) != null) {
                this.notify(eventListeners, event);
            }
        }

        private void notify(Collection<EventListener> listeners, InboundEvent event) {
            for (EventListener listener : listeners) {
                this.notify(listener, event);
            }
        }

        private void notify(EventListener listener, InboundEvent event) {
            try {
                listener.onEvent(event);
            }
            catch (Exception ex) {
                logger.warn(String.format("Event notification in a listener of %s class failed.", listener.getClass().getName()), (Throwable)ex);
            }
        }

        private void scheduleReconnect(long delay) {
            State s = (State)((Object)EventSource.this.state.get());
            if (s != State.OPEN) {
                logger.debug("Aborting reconnect of event source in {} state", (Object)EventSource.this.state);
                return;
            }
            EventProcessor processor = new EventProcessor(this.reconnectDelay, null, this.headers);
            if (delay > 0L) {
                EventSource.this.executor.schedule(processor, delay, TimeUnit.MILLISECONDS);
            } else {
                EventSource.this.executor.submit(processor);
            }
        }

        private Invocation.Builder prepareHandshakeRequest() {
            Invocation.Builder request = EventSource.this.target.request(new MediaType[]{SseFeature.SERVER_SENT_EVENTS_TYPE});
            request.headers(this.headers);
            if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                request.header("Last-Event-ID", (Object)this.lastEventId);
            }
            if (EventSource.this.disableKeepAlive) {
                request.header("Connection", (Object)"close");
            }
            return request;
        }

        public void awaitFirstContact() {
            logger.debug("Awaiting first contact signal.");
            try {
                if (this.firstContactSignal == null) {
                    return;
                }
                try {
                    this.firstContactSignal.await();
                }
                catch (InterruptedException ex) {
                    logger.warn(LocalizationMessages.EVENT_SOURCE_OPEN_CONNECTION_INTERRUPTED(), (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                logger.debug("First contact signal released.");
            }
        }
    }

    public static class Builder {
        private final WebTarget endpoint;
        private long reconnect = 500L;
        private String name = null;
        private boolean disableKeepAlive = true;
        private MultivaluedMap<String, Object> headers = new StringKeyIgnoreCaseMultivaluedMap();

        private Builder(WebTarget endpoint) {
            this.endpoint = endpoint;
        }

        public Builder named(String name) {
            this.name = name;
            return this;
        }

        public Builder usePersistentConnections() {
            this.disableKeepAlive = false;
            return this;
        }

        public Builder header(String name, Object value) {
            if (value == null) {
                this.headers.remove((Object)name);
            } else {
                this.headers.add((Object)name, value);
            }
            return this;
        }

        public Builder reconnectingEvery(long delay, TimeUnit unit) {
            this.reconnect = unit.toMillis(delay);
            return this;
        }

        public EventSource build() {
            return new EventSource(this.endpoint, this.name, this.reconnect, this.disableKeepAlive, false, this.headers);
        }

        public EventSource open() {
            EventSource source = new EventSource(this.endpoint, this.name, this.reconnect, this.disableKeepAlive, false, this.headers);
            source.open();
            return source;
        }
    }

    private static enum State {
        READY,
        OPEN,
        CLOSED;

    }
}

