/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.LDClient;
import java.net.URI;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDConfig {
    private static final URI DEFAULT_BASE_URI = URI.create("https://app.launchdarkly.com");
    private static final int DEFAULT_CAPACITY = 10000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 2;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10;
    private static final int DEFAULT_FLUSH_INTERVAL = 5;
    private static final Logger logger = LoggerFactory.getLogger(LDConfig.class);
    protected static final LDConfig DEFAULT = new Builder().build();
    final URI baseURI;
    final int capacity;
    final int connectTimeout;
    final int socketTimeout;
    final int flushInterval;

    protected LDConfig(Builder builder) {
        this.baseURI = builder.baseURI;
        this.capacity = builder.capacity;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.flushInterval = builder.flushInterval;
    }

    private URIBuilder getBuilder() {
        return new URIBuilder().setScheme(this.baseURI.getScheme()).setHost(this.baseURI.getHost()).setPort(this.baseURI.getPort());
    }

    HttpGet getRequest(String apiKey, String path) {
        URIBuilder builder = this.getBuilder().setPath(path);
        try {
            HttpGet request = new HttpGet(builder.build());
            request.addHeader("Authorization", "api_key " + apiKey);
            request.addHeader("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
            return request;
        }
        catch (Exception e) {
            logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
            return null;
        }
    }

    HttpPost postRequest(String apiKey, String path) {
        URIBuilder builder = this.getBuilder().setPath(path);
        try {
            HttpPost request = new HttpPost(builder.build());
            request.addHeader("Authorization", "api_key " + apiKey);
            request.addHeader("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
            return request;
        }
        catch (Exception e) {
            logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ URI access$500() {
        return DEFAULT_BASE_URI;
    }

    public static class Builder {
        private URI baseURI = LDConfig.access$500();
        private int connectTimeout = 2;
        private int socketTimeout = 10;
        private int capacity = 10000;
        private int flushInterval = 5;

        public Builder baseURI(URI baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder flushInterval(int flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

