/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.CustomEvent;
import com.launchdarkly.client.EventProcessor;
import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.FeatureRequestEvent;
import com.launchdarkly.client.IdentifyEvent;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.NewRelicReflector;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.http.HttpEntity;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LDClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(LDClient.class);
    private final LDConfig config;
    private final CloseableHttpClient client;
    private final EventProcessor eventProcessor;
    private final String apiKey;
    protected static final String CLIENT_VERSION = LDClient.getClientVersion();
    private volatile boolean offline = false;

    public LDClient(String apiKey) {
        this(apiKey, LDConfig.DEFAULT);
    }

    public LDClient(String apiKey, LDConfig config) {
        this.apiKey = apiKey;
        this.config = config;
        this.client = this.createClient();
        this.eventProcessor = this.createEventProcessor(apiKey, config);
    }

    protected EventProcessor createEventProcessor(String apiKey, LDConfig config) {
        return new EventProcessor(apiKey, config);
    }

    protected CloseableHttpClient createClient() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(100);
        manager.setDefaultMaxPerRoute(20);
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(8192L).setSharedCache(false).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.config.connectTimeout * 1000).setSocketTimeout(this.config.socketTimeout * 1000).build();
        CloseableHttpClient client = CachingHttpClients.custom().setCacheConfig(cacheConfig).setConnectionManager((HttpClientConnectionManager)manager).setDefaultRequestConfig(requestConfig).build();
        return client;
    }

    public void track(String eventName, LDUser user, JsonElement data) {
        boolean processed = this.eventProcessor.sendEvent(new CustomEvent(eventName, user, data));
        if (!processed) {
            logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
        }
    }

    public void track(String eventName, LDUser user) {
        if (this.offline) {
            return;
        }
        this.track(eventName, user, null);
    }

    public void identify(LDUser user) {
        if (this.offline) {
            return;
        }
        boolean processed = this.eventProcessor.sendEvent(new IdentifyEvent(user));
        if (!processed) {
            logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
        }
    }

    private void sendFlagRequestEvent(String featureKey, LDUser user, boolean value) {
        boolean processed = this.eventProcessor.sendEvent(new FeatureRequestEvent<Boolean>(featureKey, user, value));
        if (!processed) {
            logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
        }
        NewRelicReflector.annotateTransaction(featureKey, String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFlag(String featureKey, LDUser user, boolean defaultValue) {
        if (this.offline) {
            return defaultValue;
        }
        Gson gson = new Gson();
        HttpCacheContext context = HttpCacheContext.create();
        HttpGet request = this.config.getRequest(this.apiKey, "/api/eval/features/" + featureKey);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request, (HttpContext)context);
            CacheResponseStatus responseStatus = context.getCacheResponseStatus();
            switch (responseStatus) {
                case CACHE_HIT: {
                    logger.debug("A response was generated from the cache with no requests sent upstream");
                    break;
                }
                case CACHE_MODULE_RESPONSE: {
                    logger.debug("The response was generated directly by the caching module");
                    break;
                }
                case CACHE_MISS: {
                    logger.debug("The response came from an upstream server");
                    break;
                }
                case VALIDATED: {
                    logger.debug("The response was generated from the cache after validating the entry with the origin server");
                }
            }
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                if (status == 401) {
                    logger.error("Invalid API key");
                } else if (status == 404) {
                    logger.error("Unknown feature key: " + featureKey);
                } else {
                    logger.error("Unexpected status code: " + status);
                }
                this.sendFlagRequestEvent(featureKey, user, defaultValue);
                boolean bl = defaultValue;
                return bl;
            }
            Type boolType = new TypeToken<FeatureRep<Boolean>>(){}.getType();
            FeatureRep result = (FeatureRep)gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), boolType);
            Boolean val = (Boolean)result.evaluate(user);
            if (val == null) {
                this.sendFlagRequestEvent(featureKey, user, defaultValue);
                boolean bl = defaultValue;
                return bl;
            }
            boolean value = val;
            this.sendFlagRequestEvent(featureKey, user, value);
            boolean bl = value;
            return bl;
        }
        catch (Exception e) {
            logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
            this.sendFlagRequestEvent(featureKey, user, defaultValue);
            boolean bl = defaultValue;
            return bl;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.eventProcessor.close();
    }

    public void flush() {
        this.eventProcessor.flush();
    }

    public void setOffline() {
        this.offline = true;
    }

    public void setOnline() {
        this.offline = false;
    }

    public boolean isOffline() {
        return this.offline;
    }

    private static String getClientVersion() {
        Class<LDConfig> clazz = LDConfig.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return "Unknown";
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        Manifest manifest = null;
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Implementation-Version");
            return value;
        }
        catch (IOException e) {
            logger.warn("Unable to determine LaunchDarkly client library version", (Throwable)e);
            return "Unknown";
        }
    }
}

