/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NewRelicReflector {
    private static Class<?> newRelic = null;
    private static Method addCustomParameter = null;
    private static final Logger logger = LoggerFactory.getLogger(NewRelicReflector.class);

    NewRelicReflector() {
    }

    static void annotateTransaction(String featureKey, String value) {
        if (addCustomParameter != null) {
            try {
                addCustomParameter.invoke(null, featureKey, value);
            }
            catch (Exception e) {
                logger.error("Unexpected error in LaunchDarkly NewRelic integration");
            }
        }
    }

    static {
        try {
            newRelic = Class.forName("com.newrelic.api.agent.NewRelic");
            addCustomParameter = newRelic.getDeclaredMethod("addCustomParameter", String.class, String.class);
        }
        catch (ClassNotFoundException e) {
            logger.info("No NewRelic agent detected");
        }
        catch (NoSuchMethodException e) {
            logger.info("No NewRelic agent detected");
        }
    }
}

