/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.FeatureRequestor;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.VeryBasicFuture;
import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.eventsource.MessageEvent;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamProcessor
implements UpdateProcessor {
    private static final String PUT = "put";
    private static final String PATCH = "patch";
    private static final String DELETE = "delete";
    private static final String INDIRECT_PUT = "indirect/put";
    private static final String INDIRECT_PATCH = "indirect/patch";
    private static final Logger logger = LoggerFactory.getLogger(StreamProcessor.class);
    private final FeatureStore store;
    private final LDConfig config;
    private final String apiKey;
    private final FeatureRequestor requestor;
    private EventSource es;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    StreamProcessor(String apiKey, LDConfig config, FeatureRequestor requestor) {
        this.store = config.featureStore;
        this.config = config;
        this.apiKey = apiKey;
        this.requestor = requestor;
    }

    @Override
    public Future<Void> start() {
        final VeryBasicFuture initFuture = new VeryBasicFuture();
        Headers headers = new Headers.Builder().add("Authorization", "api_key " + this.apiKey).add("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION).add("Accept", "text/event-stream").build();
        EventHandler handler = new EventHandler(){

            public void onOpen() throws Exception {
            }

            public void onMessage(String name, MessageEvent event) throws Exception {
                Gson gson = new Gson();
                if (name.equals(StreamProcessor.PUT)) {
                    Type type = new TypeToken<Map<String, FeatureRep<?>>>(){}.getType();
                    Map features = (Map)gson.fromJson(event.getData(), type);
                    StreamProcessor.this.store.init(features);
                    if (!StreamProcessor.this.initialized.getAndSet(true)) {
                        initFuture.completed(null);
                        logger.info("Initialized LaunchDarkly client.");
                    }
                } else if (name.equals(StreamProcessor.PATCH)) {
                    FeaturePatchData data = (FeaturePatchData)gson.fromJson(event.getData(), FeaturePatchData.class);
                    StreamProcessor.this.store.upsert(data.key(), data.feature());
                } else if (name.equals(StreamProcessor.DELETE)) {
                    FeatureDeleteData data = (FeatureDeleteData)gson.fromJson(event.getData(), FeatureDeleteData.class);
                    StreamProcessor.this.store.delete(data.key(), data.version());
                } else if (name.equals(StreamProcessor.INDIRECT_PUT)) {
                    try {
                        Map<String, FeatureRep<?>> features = StreamProcessor.this.requestor.makeAllRequest(true);
                        StreamProcessor.this.store.init(features);
                        if (!StreamProcessor.this.initialized.getAndSet(true)) {
                            initFuture.completed(null);
                            logger.info("Initialized LaunchDarkly client.");
                        }
                    }
                    catch (IOException e) {
                        logger.error("Encountered exception in LaunchDarkly client", (Throwable)e);
                    }
                } else if (name.equals(StreamProcessor.INDIRECT_PATCH)) {
                    String key = event.getData();
                    try {
                        FeatureRep feature = StreamProcessor.this.requestor.makeRequest(key, true);
                        StreamProcessor.this.store.upsert(key, feature);
                    }
                    catch (IOException e) {
                        logger.error("Encountered exception in LaunchDarkly client", (Throwable)e);
                    }
                } else {
                    logger.warn("Unexpected event found in stream: " + event.getData());
                }
            }

            public void onError(Throwable throwable) {
                logger.warn("Encountered EventSource error", throwable);
            }
        };
        this.es = new EventSource.Builder(handler, URI.create(this.config.streamURI.toASCIIString() + "/features")).headers(headers).build();
        this.es.start();
        return initFuture;
    }

    @Override
    public void close() throws IOException {
        if (this.es != null) {
            this.es.close();
        }
        if (this.store != null) {
            this.store.close();
        }
    }

    @Override
    public boolean initialized() {
        return this.initialized.get();
    }

    FeatureRep<?> getFeature(String key) {
        return this.store.get(key);
    }

    private static final class FeatureDeleteData {
        String path;
        int version;

        String key() {
            return this.path.substring(1);
        }

        int version() {
            return this.version;
        }
    }

    private static final class FeaturePatchData {
        String path;
        FeatureRep<?> data;

        String key() {
            return this.path.substring(1);
        }

        FeatureRep<?> feature() {
            return this.data;
        }
    }
}

