/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.LDConfig;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventProcessor
implements Closeable {
    private final ScheduledExecutorService scheduler;
    private final Random random = new Random();
    private final BlockingQueue<Event> queue;
    private final String apiKey;
    private final LDConfig config;
    private final Consumer consumer;

    EventProcessor(String apiKey, LDConfig config) {
        this.apiKey = apiKey;
        this.queue = new ArrayBlockingQueue<Event>(config.capacity);
        this.consumer = new Consumer(config);
        this.config = config;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-EventProcessor-%d").build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduler.scheduleAtFixedRate(this.consumer, 0L, config.flushInterval, TimeUnit.SECONDS);
    }

    boolean sendEvent(Event e) {
        if (this.config.samplingInterval > 0 && this.random.nextInt(this.config.samplingInterval) != 0) {
            return true;
        }
        return this.queue.offer(e);
    }

    @Override
    public void close() throws IOException {
        this.scheduler.shutdown();
        this.flush();
    }

    public void flush() {
        this.consumer.flush();
    }

    class Consumer
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(Consumer.class);
        private final CloseableHttpClient client;
        private final LDConfig config;

        Consumer(LDConfig config) {
            this.config = config;
            this.client = HttpClients.custom().setProxy(config.proxyHost).build();
        }

        @Override
        public void run() {
            this.flush();
        }

        public void flush() {
            ArrayList<Event> events = new ArrayList<Event>(EventProcessor.this.queue.size());
            EventProcessor.this.queue.drainTo(events);
            if (!events.isEmpty()) {
                this.postEvents(events);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postEvents(List<Event> events) {
            this.logger.debug("Posting " + events.size() + " event(s)..");
            CloseableHttpResponse response = null;
            Gson gson = new Gson();
            String json = gson.toJson(events);
            HttpPost request = this.config.postEventsRequest(EventProcessor.this.apiKey, "/bulk");
            StringEntity entity = new StringEntity(json, "UTF-8");
            entity.setContentType("application/json");
            request.setEntity((HttpEntity)entity);
            try {
                response = this.client.execute((HttpUriRequest)request);
                int status = response.getStatusLine().getStatusCode();
                if (status >= 300) {
                    if (status == 401) {
                        this.logger.error("Invalid API key");
                    } else {
                        this.logger.error("Unexpected status code: " + status);
                    }
                } else {
                    this.logger.debug("Successfully posted " + events.size() + " event(s).");
                }
            }
            catch (IOException e) {
                this.logger.error("Unhandled exception in LaunchDarkly client attempting to connect to URI: " + this.config.eventsURI, (Throwable)e);
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
                }
            }
        }
    }
}

