/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.FeatureStore;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;

public class RedisFeatureStore
implements FeatureStore {
    private static final String DEFAULT_PREFIX = "launchdarkly";
    private final JedisPool pool;
    private LoadingCache<String, FeatureRep<?>> cache;
    private LoadingCache<String, Boolean> initCache;
    private String prefix;
    private static final String INIT_KEY = "$initialized$";

    public RedisFeatureStore(String host, int port, String prefix, long cacheTimeSecs) {
        this(host, port, prefix, cacheTimeSecs, RedisFeatureStore.getPoolConfig());
    }

    public RedisFeatureStore(URI uri, String prefix, long cacheTimeSecs) {
        this(uri, prefix, cacheTimeSecs, RedisFeatureStore.getPoolConfig());
    }

    public RedisFeatureStore(String host, int port, String prefix, long cacheTimeSecs, JedisPoolConfig poolConfig) {
        this.pool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port);
        this.setPrefix(prefix);
        this.createCache(cacheTimeSecs);
        this.createInitCache(cacheTimeSecs);
    }

    public RedisFeatureStore(URI uri, String prefix, long cacheTimeSecs, JedisPoolConfig poolConfig) {
        this.pool = new JedisPool((GenericObjectPoolConfig)poolConfig, uri);
        this.setPrefix(prefix);
        this.createCache(cacheTimeSecs);
        this.createInitCache(cacheTimeSecs);
    }

    public RedisFeatureStore() {
        this.pool = new JedisPool((GenericObjectPoolConfig)RedisFeatureStore.getPoolConfig(), "localhost");
        this.prefix = DEFAULT_PREFIX;
    }

    private void setPrefix(String prefix) {
        this.prefix = prefix == null || prefix.isEmpty() ? DEFAULT_PREFIX : prefix;
    }

    private void createCache(long cacheTimeSecs) {
        if (cacheTimeSecs > 0L) {
            this.cache = CacheBuilder.newBuilder().expireAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build(new CacheLoader<String, FeatureRep<?>>(){

                public FeatureRep<?> load(String key) throws Exception {
                    return RedisFeatureStore.this.getRedis(key);
                }
            });
        }
    }

    private void createInitCache(long cacheTimeSecs) {
        if (cacheTimeSecs > 0L) {
            this.initCache = CacheBuilder.newBuilder().expireAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Boolean>(){

                public Boolean load(String key) throws Exception {
                    return RedisFeatureStore.this.getInit();
                }
            });
        }
    }

    @Override
    public FeatureRep<?> get(String key) {
        if (this.cache != null) {
            return (FeatureRep)this.cache.getUnchecked((Object)key);
        }
        return this.getRedis(key);
    }

    @Override
    public Map<String, FeatureRep<?>> all() {
        try (Jedis jedis = this.pool.getResource();){
            Map featuresJson = jedis.hgetAll(this.featuresKey());
            HashMap result = new HashMap();
            Gson gson = new Gson();
            Type type = new TypeToken<FeatureRep<?>>(){}.getType();
            for (Map.Entry entry : featuresJson.entrySet()) {
                FeatureRep rep = (FeatureRep)gson.fromJson((String)entry.getValue(), type);
                result.put(entry.getKey(), rep);
            }
            HashMap hashMap = result;
            return hashMap;
        }
    }

    @Override
    public void init(Map<String, FeatureRep<?>> features) {
        try (Jedis jedis = this.pool.getResource();){
            Gson gson = new Gson();
            Transaction t = jedis.multi();
            t.del(this.featuresKey());
            for (FeatureRep<?> f : features.values()) {
                t.hset(this.featuresKey(), f.key, gson.toJson(f));
            }
            t.exec();
        }
    }

    @Override
    public void delete(String key, int version) {
        try (Jedis jedis = this.pool.getResource();){
            Gson gson = new Gson();
            jedis.watch(new String[]{this.featuresKey()});
            FeatureRep<?> feature = this.getRedis(key);
            if (feature != null && feature.version >= version) {
                return;
            }
            feature.deleted = true;
            feature.version = version;
            jedis.hset(this.featuresKey(), key, gson.toJson(feature));
            if (this.cache != null) {
                this.cache.invalidate((Object)key);
            }
        }
    }

    @Override
    public void upsert(String key, FeatureRep<?> feature) {
        try (Jedis jedis = this.pool.getResource();){
            Gson gson = new Gson();
            jedis.watch(new String[]{this.featuresKey()});
            FeatureRep<?> f = this.getRedis(key);
            if (f != null && f.version >= feature.version) {
                return;
            }
            jedis.hset(this.featuresKey(), key, gson.toJson(feature));
            if (this.cache != null) {
                this.cache.invalidate((Object)key);
            }
        }
    }

    @Override
    public boolean initialized() {
        Boolean initialized;
        if (this.initCache != null && (initialized = (Boolean)this.initCache.getUnchecked((Object)INIT_KEY)) != null && initialized.booleanValue()) {
            return true;
        }
        return this.getInit();
    }

    @Override
    public void close() throws IOException {
        this.pool.destroy();
    }

    private String featuresKey() {
        return this.prefix + ":features";
    }

    private Boolean getInit() {
        try (Jedis jedis = this.pool.getResource();){
            Boolean bl = jedis.exists(this.featuresKey());
            return bl;
        }
    }

    private FeatureRep<?> getRedis(String key) {
        try (Jedis jedis = this.pool.getResource();){
            Gson gson = new Gson();
            String featureJson = jedis.hget(this.featuresKey(), key);
            if (featureJson == null) {
                FeatureRep<?> featureRep = null;
                return featureRep;
            }
            Type type = new TypeToken<FeatureRep<?>>(){}.getType();
            FeatureRep f = (FeatureRep)gson.fromJson(featureJson, type);
            FeatureRep featureRep = f.deleted ? null : f;
            return featureRep;
        }
    }

    private static final JedisPoolConfig getPoolConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        return config;
    }
}

