/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.FeatureRep;
import com.launchdarkly.client.LDConfig;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeatureRequestor {
    private final String apiKey;
    private final LDConfig config;
    private final CloseableHttpClient client;
    private static final Logger logger = LoggerFactory.getLogger(FeatureRequestor.class);

    FeatureRequestor(String apiKey, LDConfig config) {
        this.apiKey = apiKey;
        this.config = config;
        this.client = this.createClient();
    }

    protected CloseableHttpClient createClient() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(100);
        manager.setDefaultMaxPerRoute(20);
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).setSharedCache(false).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.config.connectTimeout).setSocketTimeout(this.config.socketTimeout).setProxy(this.config.proxyHost).build();
        CloseableHttpClient client = CachingHttpClients.custom().setCacheConfig(cacheConfig).setConnectionManager((HttpClientConnectionManager)manager).setDefaultRequestConfig(requestConfig).build();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, FeatureRep<?>> makeAllRequest(boolean latest) throws IOException {
        Gson gson = new Gson();
        HttpCacheContext context = HttpCacheContext.create();
        String resource = latest ? "/api/eval/latest-features" : "/api/eval/features";
        HttpGet request = this.config.getRequest(this.apiKey, resource);
        CloseableHttpResponse response = null;
        try {
            Map result;
            logger.debug("Making request: " + request);
            response = this.client.execute((HttpUriRequest)request, (HttpContext)context);
            this.logCacheResponse(context.getCacheResponseStatus());
            this.handleResponseStatus(response.getStatusLine().getStatusCode(), null);
            Type type = new TypeToken<Map<String, FeatureRep<?>>>(){}.getType();
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.debug("Got response: " + response.toString());
            logger.debug("Got Response body: " + json);
            Map map = result = (Map)gson.fromJson(json, type);
            return map;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void logCacheResponse(CacheResponseStatus status) {
        switch (status) {
            case CACHE_HIT: {
                logger.debug("A response was generated from the cache with no requests sent upstream");
                break;
            }
            case CACHE_MODULE_RESPONSE: {
                logger.debug("The response was generated directly by the caching module");
                break;
            }
            case CACHE_MISS: {
                logger.debug("The response came from an upstream server");
                break;
            }
            case VALIDATED: {
                logger.debug("The response was generated from the cache after validating the entry with the origin server");
            }
        }
    }

    void handleResponseStatus(int status, String featureKey) throws IOException {
        if (status != 200) {
            if (status == 401) {
                logger.error("Invalid API key");
            } else if (status == 404) {
                if (featureKey != null) {
                    logger.error("Unknown feature key: " + featureKey);
                } else {
                    logger.error("Resource not found");
                }
            } else {
                logger.error("Unexpected status code: " + status);
            }
            throw new IOException("Failed to fetch flag");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> FeatureRep<T> makeRequest(String featureKey, boolean latest) throws IOException {
        Gson gson = new Gson();
        HttpCacheContext context = HttpCacheContext.create();
        String resource = latest ? "/api/eval/latest-features/" : "/api/eval/features/";
        HttpGet request = this.config.getRequest(this.apiKey, resource + featureKey);
        CloseableHttpResponse response = null;
        try {
            FeatureRep result;
            response = this.client.execute((HttpUriRequest)request, (HttpContext)context);
            this.logCacheResponse(context.getCacheResponseStatus());
            this.handleResponseStatus(response.getStatusLine().getStatusCode(), featureKey);
            Type type = new TypeToken<FeatureRep<T>>(){}.getType();
            FeatureRep featureRep = result = (FeatureRep)gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), type);
            return featureRep;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

