/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.InMemoryFeatureStore;
import com.launchdarkly.client.LDClient;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDConfig {
    private static final URI DEFAULT_BASE_URI = URI.create("https://app.launchdarkly.com");
    private static final URI DEFAULT_EVENTS_URI = URI.create("https://events.launchdarkly.com");
    private static final URI DEFAULT_STREAM_URI = URI.create("https://stream.launchdarkly.com");
    private static final int DEFAULT_CAPACITY = 10000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final int DEFAULT_FLUSH_INTERVAL = 5;
    private static final long DEFAULT_POLLING_INTERVAL_MILLIS = 1000L;
    private static final long DEFAULT_START_WAIT_MILLIS = 5000L;
    private static final int DEFAULT_SAMPLING_INTERVAL = 0;
    private static final Logger logger = LoggerFactory.getLogger(LDConfig.class);
    protected static final LDConfig DEFAULT = new Builder().build();
    final URI baseURI;
    final URI eventsURI;
    final URI streamURI;
    final int capacity;
    final int connectTimeout;
    final int socketTimeout;
    final int flushInterval;
    final HttpHost proxyHost;
    final boolean stream;
    final boolean debugStreaming;
    final FeatureStore featureStore;
    final boolean useLdd;
    final boolean offline;
    final long pollingIntervalMillis;
    final long startWaitMillis;
    final int samplingInterval;

    protected LDConfig(Builder builder) {
        this.baseURI = builder.baseURI;
        this.eventsURI = builder.eventsURI;
        this.capacity = builder.capacity;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.flushInterval = builder.flushInterval;
        this.proxyHost = builder.proxyHost();
        this.streamURI = builder.streamURI;
        this.stream = builder.stream;
        this.debugStreaming = builder.debugStreaming;
        this.featureStore = builder.featureStore;
        this.useLdd = builder.useLdd;
        this.offline = builder.offline;
        this.pollingIntervalMillis = builder.pollingIntervalMillis < 1000L ? 1000L : builder.pollingIntervalMillis;
        this.startWaitMillis = builder.startWaitMillis;
        this.samplingInterval = builder.samplingInterval;
    }

    private URIBuilder getBuilder() {
        return new URIBuilder().setScheme(this.baseURI.getScheme()).setHost(this.baseURI.getHost()).setPort(this.baseURI.getPort());
    }

    private URIBuilder getEventsBuilder() {
        return new URIBuilder().setScheme(this.eventsURI.getScheme()).setHost(this.eventsURI.getHost()).setPort(this.eventsURI.getPort());
    }

    HttpGet getRequest(String apiKey, String path) {
        URIBuilder builder = this.getBuilder().setPath(path);
        try {
            HttpGet request = new HttpGet(builder.build());
            request.addHeader("Authorization", "api_key " + apiKey);
            request.addHeader("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
            return request;
        }
        catch (Exception e) {
            logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
            return null;
        }
    }

    HttpPost postRequest(String apiKey, String path) {
        URIBuilder builder = this.getBuilder().setPath(path);
        try {
            HttpPost request = new HttpPost(builder.build());
            request.addHeader("Authorization", "api_key " + apiKey);
            request.addHeader("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
            return request;
        }
        catch (Exception e) {
            logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
            return null;
        }
    }

    HttpPost postEventsRequest(String apiKey, String path) {
        URIBuilder builder = this.getEventsBuilder().setPath(this.eventsURI.getPath() + path);
        try {
            HttpPost request = new HttpPost(builder.build());
            request.addHeader("Authorization", "api_key " + apiKey);
            request.addHeader("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
            return request;
        }
        catch (Exception e) {
            logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ URI access$1500() {
        return DEFAULT_BASE_URI;
    }

    static /* synthetic */ URI access$1600() {
        return DEFAULT_EVENTS_URI;
    }

    static /* synthetic */ URI access$1700() {
        return DEFAULT_STREAM_URI;
    }

    public static class Builder {
        private URI baseURI = LDConfig.access$1500();
        private URI eventsURI = LDConfig.access$1600();
        private URI streamURI = LDConfig.access$1700();
        private int connectTimeout = 2000;
        private int socketTimeout = 10000;
        private int capacity = 10000;
        private int flushInterval = 5;
        private String proxyHost;
        private int proxyPort = -1;
        private String proxyScheme;
        private boolean stream = true;
        private boolean debugStreaming = false;
        private boolean useLdd = false;
        private boolean offline = false;
        private long pollingIntervalMillis = 1000L;
        private FeatureStore featureStore = new InMemoryFeatureStore();
        private long startWaitMillis = 5000L;
        private int samplingInterval = 0;

        public Builder baseURI(URI baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        public Builder eventsURI(URI eventsURI) {
            this.eventsURI = eventsURI;
            return this;
        }

        public Builder streamURI(URI streamURI) {
            this.streamURI = streamURI;
            return this;
        }

        public Builder featureStore(FeatureStore store) {
            this.featureStore = store;
            return this;
        }

        public Builder debugStreaming(boolean debugStreaming) {
            this.debugStreaming = debugStreaming;
            return this;
        }

        public Builder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout * 1000;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout * 1000;
            return this;
        }

        public Builder connectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeout = connectTimeoutMillis;
            return this;
        }

        public Builder socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeout = socketTimeoutMillis;
            return this;
        }

        public Builder flushInterval(int flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder proxyHost(String host) {
            this.proxyHost = host;
            return this;
        }

        public Builder proxyPort(int port) {
            this.proxyPort = port;
            return this;
        }

        public Builder proxyScheme(String scheme) {
            this.proxyScheme = scheme;
            return this;
        }

        public Builder useLdd(boolean useLdd) {
            this.useLdd = useLdd;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder pollingIntervalMillis(long pollingIntervalMillis) {
            this.pollingIntervalMillis = pollingIntervalMillis;
            return this;
        }

        public Builder startWaitMillis(long startWaitMillis) {
            this.startWaitMillis = startWaitMillis;
            return this;
        }

        public Builder samplingInterval(int samplingInterval) {
            this.samplingInterval = samplingInterval;
            return this;
        }

        HttpHost proxyHost() {
            if (this.proxyHost == null && this.proxyPort == -1 && this.proxyScheme == null) {
                return null;
            }
            String hostname = this.proxyHost == null ? "localhost" : this.proxyHost;
            String scheme = this.proxyScheme == null ? "https" : this.proxyScheme;
            return new HttpHost(hostname, this.proxyPort, scheme);
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

