/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.RedisFeatureStore;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.utils.URIBuilder;
import redis.clients.jedis.JedisPoolConfig;

public class RedisFeatureStoreBuilder {
    protected boolean refreshStaleValues = false;
    protected boolean asyncRefresh = false;
    protected URI uri;
    protected String prefix;
    protected int connectTimeout = 2000;
    protected int socketTimeout = 2000;
    protected long cacheTimeSecs;
    protected JedisPoolConfig poolConfig;

    public RedisFeatureStoreBuilder(URI uri, long cacheTimeSecs) {
        this.uri = uri;
        this.cacheTimeSecs = cacheTimeSecs;
    }

    public RedisFeatureStoreBuilder(String scheme, String host, int port, long cacheTimeSecs) throws URISyntaxException {
        this.uri = new URIBuilder().setScheme(scheme).setHost(host).setPort(port).build();
        this.cacheTimeSecs = cacheTimeSecs;
    }

    public RedisFeatureStoreBuilder refreshStaleValues(boolean enabled) {
        this.refreshStaleValues = enabled;
        return this;
    }

    public RedisFeatureStoreBuilder asyncRefresh(boolean enabled) {
        this.asyncRefresh = enabled;
        return this;
    }

    public RedisFeatureStoreBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public RedisFeatureStoreBuilder cacheTime(long cacheTime, TimeUnit timeUnit) {
        this.cacheTimeSecs = timeUnit.toSeconds(cacheTime);
        return this;
    }

    public RedisFeatureStoreBuilder poolConfig(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public RedisFeatureStoreBuilder connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeout = (int)timeUnit.toMillis(connectTimeout);
        return this;
    }

    public RedisFeatureStoreBuilder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
        this.socketTimeout = (int)timeUnit.toMillis(socketTimeout);
        return this;
    }

    public RedisFeatureStore build() {
        return new RedisFeatureStore(this);
    }
}

