/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureRequestor;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.VeryBasicFuture;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.org.slf4j.Logger;
import com.launchdarkly.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class PollingProcessor
implements UpdateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PollingProcessor.class);
    private final FeatureRequestor requestor;
    private final LDConfig config;
    private final FeatureStore store;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private ScheduledExecutorService scheduler = null;

    PollingProcessor(LDConfig config, FeatureRequestor requestor) {
        this.requestor = requestor;
        this.config = config;
        this.store = config.featureStore;
    }

    @Override
    public boolean initialized() {
        return this.initialized.get();
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly PollingProcessor");
        this.scheduler.shutdown();
    }

    @Override
    public Future<Void> start() {
        logger.info("Starting LaunchDarkly polling client with interval: " + this.config.pollingIntervalMillis + " milliseconds");
        final VeryBasicFuture initFuture = new VeryBasicFuture();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("LaunchDarkly-PollingProcessor-%d").build();
        this.scheduler = Executors.newScheduledThreadPool(1, threadFactory);
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    PollingProcessor.this.store.init(PollingProcessor.this.requestor.getAllFlags());
                    if (!PollingProcessor.this.initialized.getAndSet(true)) {
                        logger.info("Initialized LaunchDarkly client.");
                        initFuture.completed(null);
                    }
                }
                catch (IOException e) {
                    logger.error("Encountered exception in LaunchDarkly client when retrieving update", (Throwable)e);
                }
            }
        }, 0L, this.config.pollingIntervalMillis, TimeUnit.MILLISECONDS);
        return initFuture;
    }
}

