/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FeatureRequestor;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.VeryBasicFuture;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.org.slf4j.Logger;
import com.launchdarkly.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

class StreamProcessor
implements UpdateProcessor {
    private static final String PUT = "put";
    private static final String PATCH = "patch";
    private static final String DELETE = "delete";
    private static final String INDIRECT_PUT = "indirect/put";
    private static final String INDIRECT_PATCH = "indirect/patch";
    private static final Logger logger = LoggerFactory.getLogger(StreamProcessor.class);
    private final FeatureStore store;
    private final LDConfig config;
    private final String sdkKey;
    private final FeatureRequestor requestor;
    private EventSource es;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    StreamProcessor(String sdkKey, LDConfig config, FeatureRequestor requestor) {
        this.store = config.featureStore;
        this.config = config;
        this.sdkKey = sdkKey;
        this.requestor = requestor;
    }

    @Override
    public Future<Void> start() {
        final VeryBasicFuture initFuture = new VeryBasicFuture();
        Headers headers = new Headers.Builder().add("Authorization", this.sdkKey).add("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION).add("Accept", "text/event-stream").build();
        EventHandler handler = new EventHandler(){

            @Override
            public void onOpen() throws Exception {
            }

            @Override
            public void onMessage(String name, MessageEvent event) throws Exception {
                Gson gson = new Gson();
                switch (name) {
                    case "put": {
                        StreamProcessor.this.store.init(FeatureFlag.fromJsonMap(event.getData()));
                        if (StreamProcessor.this.initialized.getAndSet(true)) break;
                        initFuture.completed(null);
                        logger.info("Initialized LaunchDarkly client.");
                        break;
                    }
                    case "patch": {
                        FeaturePatchData data = gson.fromJson(event.getData(), FeaturePatchData.class);
                        StreamProcessor.this.store.upsert(data.key(), data.feature());
                        break;
                    }
                    case "delete": {
                        FeatureDeleteData data = gson.fromJson(event.getData(), FeatureDeleteData.class);
                        StreamProcessor.this.store.delete(data.key(), data.version());
                        break;
                    }
                    case "indirect/put": {
                        try {
                            StreamProcessor.this.store.init(StreamProcessor.this.requestor.getAllFlags());
                            if (StreamProcessor.this.initialized.getAndSet(true)) break;
                            initFuture.completed(null);
                            logger.info("Initialized LaunchDarkly client.");
                        }
                        catch (IOException e) {
                            logger.error("Encountered exception in LaunchDarkly client", (Throwable)e);
                        }
                        break;
                    }
                    case "indirect/patch": {
                        String key = event.getData();
                        try {
                            FeatureFlag feature = StreamProcessor.this.requestor.getFlag(key);
                            StreamProcessor.this.store.upsert(key, feature);
                        }
                        catch (IOException e) {
                            logger.error("Encountered exception in LaunchDarkly client", (Throwable)e);
                        }
                        break;
                    }
                    default: {
                        logger.warn("Unexpected event found in stream: " + event.getData());
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.error("Encountered EventSource error: " + throwable.getMessage());
                logger.debug("", throwable);
            }
        };
        this.es = new EventSource.Builder(handler, URI.create(this.config.streamURI.toASCIIString() + "/flags")).headers(headers).build();
        this.es.start();
        return initFuture;
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly StreamProcessor");
        if (this.es != null) {
            this.es.close();
        }
        if (this.store != null) {
            this.store.close();
        }
    }

    @Override
    public boolean initialized() {
        return this.initialized.get();
    }

    FeatureFlag getFeature(String key) {
        return this.store.get(key);
    }

    private static final class FeatureDeleteData {
        String path;
        int version;

        String key() {
            return this.path.substring(1);
        }

        int version() {
            return this.version;
        }
    }

    private static final class FeaturePatchData {
        String path;
        FeatureFlag data;

        String key() {
            return this.path.substring(1);
        }

        FeatureFlag feature() {
            return this.data;
        }
    }
}

