/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonPrimitive;
import com.launchdarkly.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import com.launchdarkly.shaded.org.apache.http.client.methods.HttpRequestBase;
import com.launchdarkly.shaded.org.joda.time.DateTime;
import com.launchdarkly.shaded.org.joda.time.DateTimeZone;
import com.launchdarkly.shaded.org.slf4j.Logger;

class Util {
    Util() {
    }

    protected static DateTime jsonPrimitiveToDateTime(JsonPrimitive maybeDate) {
        if (maybeDate.isNumber()) {
            long millis = maybeDate.getAsLong();
            return new DateTime(millis);
        }
        if (maybeDate.isString()) {
            try {
                return new DateTime((Object)maybeDate.getAsString(), DateTimeZone.UTC);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    static boolean handleResponse(Logger logger, HttpRequestBase request, CloseableHttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode / 100 == 2) {
            return true;
        }
        if (statusCode == 401) {
            logger.error("[401] Invalid SDK key when accessing URI: " + request.getURI().toString());
        } else {
            logger.error("[" + statusCode + "] " + response.getStatusLine().getReasonPhrase() + " When accessing URI: " + request.getURI().toString());
        }
        return false;
    }
}

