/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.shaded.org.slf4j.Logger;
import com.launchdarkly.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

class Variation<E> {
    E value;
    int weight;
    TargetRule userTarget;
    List<TargetRule> targets;
    private static final Logger logger = LoggerFactory.getLogger(Variation.class);

    public Variation() {
    }

    public String toString() {
        return "Variation{value=" + this.value + ", weight=" + this.weight + ", userTarget=" + this.userTarget + ", targets=" + this.targets + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variation variation = (Variation)o;
        if (this.weight != variation.weight) {
            return false;
        }
        if (this.value != null ? !this.value.equals(variation.value) : variation.value != null) {
            return false;
        }
        if (this.userTarget != null ? !this.userTarget.equals(variation.userTarget) : variation.userTarget != null) {
            return false;
        }
        return this.targets != null ? this.targets.equals(variation.targets) : variation.targets == null;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.weight;
        result = 31 * result + (this.userTarget != null ? this.userTarget.hashCode() : 0);
        result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
        return result;
    }

    Variation(Builder<E> b) {
        this.value = b.value;
        this.weight = b.weight;
        this.userTarget = b.userTarget;
        this.targets = new ArrayList<TargetRule>(b.targets);
    }

    public boolean matchUser(LDUser user) {
        return this.userTarget != null && this.userTarget.matchTarget(user);
    }

    public boolean matchTarget(LDUser user) {
        for (TargetRule target : this.targets) {
            if (this.userTarget != null && target.attribute.equals("key") || !target.matchTarget(user)) continue;
            return true;
        }
        return false;
    }

    static class TargetRule {
        String attribute;
        String operator;
        List<JsonPrimitive> values;
        private static final Logger logger = LoggerFactory.getLogger(TargetRule.class);

        public TargetRule() {
        }

        TargetRule(String attribute, String operator, List<JsonPrimitive> values) {
            this.attribute = attribute;
            this.operator = operator;
            this.values = new ArrayList<JsonPrimitive>(values);
        }

        TargetRule(String attribute, List<JsonPrimitive> values) {
            this(attribute, "in", values);
        }

        public boolean matchTarget(LDUser user) {
            JsonPrimitive uValue = null;
            if (this.attribute.equals("key")) {
                if (user.getKey() != null) {
                    uValue = user.getKey();
                }
            } else if (this.attribute.equals("ip") && user.getIp() != null) {
                if (user.getIp() != null) {
                    uValue = user.getIp();
                }
            } else if (this.attribute.equals("country")) {
                if (user.getCountry() != null) {
                    uValue = user.getCountry();
                }
            } else if (this.attribute.equals("email")) {
                if (user.getEmail() != null) {
                    uValue = user.getEmail();
                }
            } else if (this.attribute.equals("firstName")) {
                if (user.getFirstName() != null) {
                    uValue = user.getFirstName();
                }
            } else if (this.attribute.equals("lastName")) {
                if (user.getLastName() != null) {
                    uValue = user.getLastName();
                }
            } else if (this.attribute.equals("avatar")) {
                if (user.getAvatar() != null) {
                    uValue = user.getAvatar();
                }
            } else if (this.attribute.equals("name")) {
                if (user.getName() != null) {
                    uValue = user.getName();
                }
            } else if (this.attribute.equals("anonymous")) {
                if (user.getAnonymous() != null) {
                    uValue = user.getAnonymous();
                }
            } else {
                JsonElement custom = user.getCustom(this.attribute);
                if (custom != null) {
                    if (custom.isJsonArray()) {
                        JsonArray array = custom.getAsJsonArray();
                        for (JsonElement elt : array) {
                            if (!elt.isJsonPrimitive()) {
                                logger.error("Invalid custom attribute value in user object: " + elt);
                                return false;
                            }
                            if (!this.values.contains(elt.getAsJsonPrimitive())) continue;
                            return true;
                        }
                        return false;
                    }
                    if (custom.isJsonPrimitive()) {
                        return this.values.contains(custom.getAsJsonPrimitive());
                    }
                }
                return false;
            }
            if (uValue == null) {
                return false;
            }
            return this.values.contains(uValue);
        }
    }

    static class Builder<E> {
        E value;
        int weight;
        TargetRule userTarget;
        List<TargetRule> targets;

        Builder(E value, int weight) {
            this.value = value;
            this.weight = weight;
            this.userTarget = new TargetRule("key", "in", new ArrayList<JsonPrimitive>());
            this.targets = new ArrayList<TargetRule>();
        }

        Builder<E> userTarget(TargetRule rule) {
            this.userTarget = rule;
            return this;
        }

        Builder<E> target(TargetRule rule) {
            this.targets.add(rule);
            return this;
        }

        Variation<E> build() {
            return new Variation(this);
        }
    }
}

