/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.redis.clients.jedis;

import com.launchdarkly.shaded.redis.clients.jedis.Jedis;
import com.launchdarkly.shaded.redis.clients.jedis.JedisClusterConnectionHandler;
import com.launchdarkly.shaded.redis.clients.jedis.exceptions.JedisAskDataException;
import com.launchdarkly.shaded.redis.clients.jedis.exceptions.JedisClusterException;
import com.launchdarkly.shaded.redis.clients.jedis.exceptions.JedisClusterMaxRedirectionsException;
import com.launchdarkly.shaded.redis.clients.jedis.exceptions.JedisConnectionException;
import com.launchdarkly.shaded.redis.clients.jedis.exceptions.JedisMovedDataException;
import com.launchdarkly.shaded.redis.clients.jedis.exceptions.JedisRedirectionException;
import com.launchdarkly.shaded.redis.clients.util.JedisClusterCRC16;
import com.launchdarkly.shaded.redis.clients.util.SafeEncoder;

public abstract class JedisClusterCommand<T> {
    private JedisClusterConnectionHandler connectionHandler;
    private int redirections;
    private ThreadLocal<Jedis> askConnection = new ThreadLocal();

    public JedisClusterCommand(JedisClusterConnectionHandler connectionHandler, int maxRedirections) {
        this.connectionHandler = connectionHandler;
        this.redirections = maxRedirections;
    }

    public abstract T execute(Jedis var1);

    public T run(String key) {
        if (key == null) {
            throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
        }
        return this.runWithRetries(SafeEncoder.encode(key), this.redirections, false, false);
    }

    public T run(int keyCount, String ... keys) {
        if (keys == null || keys.length == 0) {
            throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
        }
        if (keys.length > 1) {
            int slot = JedisClusterCRC16.getSlot(keys[0]);
            for (int i = 1; i < keyCount; ++i) {
                int nextSlot = JedisClusterCRC16.getSlot(keys[i]);
                if (slot == nextSlot) continue;
                throw new JedisClusterException("No way to dispatch this command to Redis Cluster because keys have different slots.");
            }
        }
        return this.runWithRetries(SafeEncoder.encode(keys[0]), this.redirections, false, false);
    }

    public T runBinary(byte[] key) {
        if (key == null) {
            throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
        }
        return this.runWithRetries(key, this.redirections, false, false);
    }

    public T runBinary(int keyCount, byte[] ... keys) {
        if (keys == null || keys.length == 0) {
            throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
        }
        if (keys.length > 1) {
            int slot = JedisClusterCRC16.getSlot(keys[0]);
            for (int i = 1; i < keyCount; ++i) {
                int nextSlot = JedisClusterCRC16.getSlot(keys[i]);
                if (slot == nextSlot) continue;
                throw new JedisClusterException("No way to dispatch this command to Redis Cluster because keys have different slots.");
            }
        }
        return this.runWithRetries(keys[0], this.redirections, false, false);
    }

    public T runWithAnyNode() {
        Jedis connection = null;
        try {
            connection = this.connectionHandler.getConnection();
            T t = this.execute(connection);
            return t;
        }
        catch (JedisConnectionException e) {
            throw e;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private T runWithRetries(byte[] key, int redirections, boolean tryRandomNode, boolean asking) {
        T t;
        if (redirections <= 0) {
            throw new JedisClusterMaxRedirectionsException("Too many Cluster redirections?");
        }
        Jedis connection = null;
        try {
            if (asking) {
                connection = this.askConnection.get();
                connection.asking();
                asking = false;
            } else {
                connection = tryRandomNode ? this.connectionHandler.getConnection() : this.connectionHandler.getConnectionFromSlot(JedisClusterCRC16.getSlot(key));
            }
            t = this.execute(connection);
        }
        catch (JedisConnectionException jce) {
            if (tryRandomNode) {
                throw jce;
            }
            this.releaseConnection(connection);
            connection = null;
            T t2 = this.runWithRetries(key, redirections - 1, true, asking);
            this.releaseConnection(connection);
            return t2;
        }
        catch (JedisRedirectionException jre) {
            if (jre instanceof JedisMovedDataException) {
                this.connectionHandler.renewSlotCache(connection);
            }
            this.releaseConnection(connection);
            connection = null;
            if (jre instanceof JedisAskDataException) {
                asking = true;
                this.askConnection.set(this.connectionHandler.getConnectionFromNode(jre.getTargetNode()));
            } else if (!(jre instanceof JedisMovedDataException)) {
                throw new JedisClusterException(jre);
            }
            T t3 = this.runWithRetries(key, redirections - 1, false, asking);
            this.releaseConnection(connection);
            {
                catch (Throwable throwable) {
                    this.releaseConnection(connection);
                    throw throwable;
                }
            }
            return t3;
        }
        this.releaseConnection(connection);
        return t;
    }

    private void releaseConnection(Jedis connection) {
        if (connection != null) {
            connection.close();
        }
    }
}

