/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.redis.clients.jedis;

import com.launchdarkly.shaded.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import com.launchdarkly.shaded.redis.clients.jedis.Client;
import com.launchdarkly.shaded.redis.clients.jedis.HostAndPort;
import com.launchdarkly.shaded.redis.clients.jedis.Jedis;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPool;
import com.launchdarkly.shaded.redis.clients.util.SafeEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JedisClusterInfoCache {
    private Map<String, JedisPool> nodes = new HashMap<String, JedisPool>();
    private Map<Integer, JedisPool> slots = new HashMap<Integer, JedisPool>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final GenericObjectPoolConfig poolConfig;
    private int connectionTimeout;
    private int soTimeout;
    private static final int MASTER_NODE_INDEX = 2;

    public JedisClusterInfoCache(GenericObjectPoolConfig poolConfig, int timeout) {
        this(poolConfig, timeout, timeout);
    }

    public JedisClusterInfoCache(GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout) {
        this.poolConfig = poolConfig;
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverClusterNodesAndSlots(Jedis jedis) {
        this.w.lock();
        try {
            this.nodes.clear();
            this.slots.clear();
            List<Object> slots = jedis.clusterSlots();
            for (Object slotInfoObj : slots) {
                List slotInfo = (List)slotInfoObj;
                if (slotInfo.size() <= 2) continue;
                List<Integer> slotNums = this.getAssignedSlotArray(slotInfo);
                int size = slotInfo.size();
                for (int i = 2; i < size; ++i) {
                    List hostInfos = (List)slotInfo.get(i);
                    if (hostInfos.size() <= 0) continue;
                    HostAndPort targetNode = this.generateHostAndPort(hostInfos);
                    this.setNodeIfNotExist(targetNode);
                    if (i != 2) continue;
                    this.assignSlotsToNode(slotNums, targetNode);
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverClusterSlots(Jedis jedis) {
        this.w.lock();
        try {
            this.slots.clear();
            List<Object> slots = jedis.clusterSlots();
            for (Object slotInfoObj : slots) {
                List slotInfo = (List)slotInfoObj;
                if (slotInfo.size() <= 2) continue;
                List<Integer> slotNums = this.getAssignedSlotArray(slotInfo);
                List hostInfos = (List)slotInfo.get(2);
                if (hostInfos.size() <= 0) continue;
                HostAndPort targetNode = this.generateHostAndPort(hostInfos);
                this.setNodeIfNotExist(targetNode);
                this.assignSlotsToNode(slotNums, targetNode);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private HostAndPort generateHostAndPort(List<Object> hostInfos) {
        return new HostAndPort(SafeEncoder.encode((byte[])hostInfos.get(0)), ((Long)hostInfos.get(1)).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeIfNotExist(HostAndPort node) {
        this.w.lock();
        try {
            String nodeKey = JedisClusterInfoCache.getNodeKey(node);
            if (this.nodes.containsKey(nodeKey)) {
                return;
            }
            JedisPool nodePool = new JedisPool(this.poolConfig, node.getHost(), node.getPort(), this.connectionTimeout, this.soTimeout, null, 0, null);
            this.nodes.put(nodeKey, nodePool);
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotToNode(int slot, HostAndPort targetNode) {
        this.w.lock();
        try {
            JedisPool targetPool = this.nodes.get(JedisClusterInfoCache.getNodeKey(targetNode));
            if (targetPool == null) {
                this.setNodeIfNotExist(targetNode);
                targetPool = this.nodes.get(JedisClusterInfoCache.getNodeKey(targetNode));
            }
            this.slots.put(slot, targetPool);
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotsToNode(List<Integer> targetSlots, HostAndPort targetNode) {
        this.w.lock();
        try {
            JedisPool targetPool = this.nodes.get(JedisClusterInfoCache.getNodeKey(targetNode));
            if (targetPool == null) {
                this.setNodeIfNotExist(targetNode);
                targetPool = this.nodes.get(JedisClusterInfoCache.getNodeKey(targetNode));
            }
            for (Integer slot : targetSlots) {
                this.slots.put(slot, targetPool);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public JedisPool getNode(String nodeKey) {
        this.r.lock();
        try {
            JedisPool jedisPool = this.nodes.get(nodeKey);
            return jedisPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public JedisPool getSlotPool(int slot) {
        this.r.lock();
        try {
            JedisPool jedisPool = this.slots.get(slot);
            return jedisPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public Map<String, JedisPool> getNodes() {
        this.r.lock();
        try {
            HashMap<String, JedisPool> hashMap = new HashMap<String, JedisPool>(this.nodes);
            return hashMap;
        }
        finally {
            this.r.unlock();
        }
    }

    public static String getNodeKey(HostAndPort hnp) {
        return hnp.getHost() + ":" + hnp.getPort();
    }

    public static String getNodeKey(Client client) {
        return client.getHost() + ":" + client.getPort();
    }

    public static String getNodeKey(Jedis jedis) {
        return JedisClusterInfoCache.getNodeKey(jedis.getClient());
    }

    private List<Integer> getAssignedSlotArray(List<Object> slotInfo) {
        ArrayList<Integer> slotNums = new ArrayList<Integer>();
        for (int slot = ((Long)slotInfo.get(0)).intValue(); slot <= ((Long)slotInfo.get(1)).intValue(); ++slot) {
            slotNums.add(slot);
        }
        return slotNums;
    }
}

