/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.redis.clients.jedis;

import com.launchdarkly.shaded.redis.clients.jedis.Protocol;
import com.launchdarkly.shaded.redis.clients.util.SafeEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ScanParams {
    private List<byte[]> params = new ArrayList<byte[]>();
    public static final String SCAN_POINTER_START = String.valueOf(0);
    public static final byte[] SCAN_POINTER_START_BINARY = SafeEncoder.encode(SCAN_POINTER_START);

    public ScanParams match(byte[] pattern) {
        this.params.add(Protocol.Keyword.MATCH.raw);
        this.params.add(pattern);
        return this;
    }

    public ScanParams match(String pattern) {
        this.params.add(Protocol.Keyword.MATCH.raw);
        this.params.add(SafeEncoder.encode(pattern));
        return this;
    }

    public ScanParams count(int count) {
        this.params.add(Protocol.Keyword.COUNT.raw);
        this.params.add(Protocol.toByteArray(count));
        return this;
    }

    public Collection<byte[]> getParams() {
        return Collections.unmodifiableCollection(this.params);
    }
}

