/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.Util;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import com.launchdarkly.shaded.org.apache.http.client.methods.HttpPost;
import com.launchdarkly.shaded.org.apache.http.entity.StringEntity;
import com.launchdarkly.shaded.org.apache.http.impl.client.CloseableHttpClient;
import com.launchdarkly.shaded.org.apache.http.impl.client.HttpClients;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventProcessor
implements Closeable {
    private final ScheduledExecutorService scheduler;
    private final Random random = new Random();
    private final BlockingQueue<Event> queue;
    private final String sdkKey;
    private final LDConfig config;
    private final Consumer consumer;

    EventProcessor(String sdkKey, LDConfig config) {
        this.sdkKey = sdkKey;
        this.queue = new ArrayBlockingQueue<Event>(config.capacity);
        this.consumer = new Consumer(config);
        this.config = config;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-EventProcessor-%d").build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduler.scheduleAtFixedRate(this.consumer, 0L, config.flushInterval, TimeUnit.SECONDS);
    }

    boolean sendEvent(Event e) {
        if (this.config.samplingInterval > 0 && this.random.nextInt(this.config.samplingInterval) != 0) {
            return true;
        }
        return this.queue.offer(e);
    }

    @Override
    public void close() throws IOException {
        this.scheduler.shutdown();
        this.flush();
    }

    public void flush() {
        this.consumer.flush();
    }

    class Consumer
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(Consumer.class);
        private final CloseableHttpClient client;
        private final LDConfig config;

        Consumer(LDConfig config) {
            this.config = config;
            this.client = HttpClients.custom().setProxy(config.proxyHost).build();
        }

        @Override
        public void run() {
            this.flush();
        }

        public void flush() {
            ArrayList<Event> events = new ArrayList<Event>(EventProcessor.this.queue.size());
            EventProcessor.this.queue.drainTo(events);
            if (!events.isEmpty()) {
                this.postEvents(events);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postEvents(List<Event> events) {
            CloseableHttpResponse response = null;
            Gson gson = new Gson();
            String json = gson.toJson(events);
            this.logger.debug("Posting " + events.size() + " event(s) to " + this.config.eventsURI + " with payload: " + json);
            HttpPost request = this.config.postEventsRequest(EventProcessor.this.sdkKey, "/bulk");
            StringEntity entity = new StringEntity(json, "UTF-8");
            entity.setContentType("application/json");
            request.setEntity(entity);
            try {
                response = this.client.execute(request);
                if (Util.handleResponse(this.logger, request, response)) {
                    this.logger.debug("Successfully posted " + events.size() + " event(s).");
                }
            }
            catch (IOException e) {
                this.logger.error("Unhandled exception in LaunchDarkly client attempting to connect to URI: " + this.config.eventsURI, (Throwable)e);
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error("Unhandled exception in LaunchDarkly client", (Throwable)e);
                }
            }
        }
    }
}

