/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sse;

import com.launchdarkly.shaded.com.launchdarkly.sse.EventHandler;
import com.launchdarkly.shaded.com.launchdarkly.sse.MessageEvent;
import java.util.concurrent.Executor;

class AsyncEventHandler
implements EventHandler {
    private final Executor executor;
    private final EventHandler eventSourceHandler;

    AsyncEventHandler(Executor executor, EventHandler eventSourceHandler) {
        this.executor = executor;
        this.eventSourceHandler = eventSourceHandler;
    }

    public void onOpen() {
        this.executor.execute(new Runnable(){

            public void run() {
                try {
                    AsyncEventHandler.this.eventSourceHandler.onOpen();
                }
                catch (Exception e) {
                    AsyncEventHandler.this.onError(e);
                }
            }
        });
    }

    public void onMessage(final String event, final MessageEvent messageEvent) {
        this.executor.execute(new Runnable(){

            public void run() {
                try {
                    AsyncEventHandler.this.eventSourceHandler.onMessage(event, messageEvent);
                }
                catch (Exception e) {
                    AsyncEventHandler.this.onError(e);
                }
            }
        });
    }

    public void onError(final Throwable error) {
        this.executor.execute(new Runnable(){

            public void run() {
                try {
                    AsyncEventHandler.this.eventSourceHandler.onError(error);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

