/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.redis.clients.jedis;

import com.launchdarkly.shaded.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import com.launchdarkly.shaded.redis.clients.jedis.HostAndPort;
import com.launchdarkly.shaded.redis.clients.jedis.Jedis;
import com.launchdarkly.shaded.redis.clients.jedis.JedisClusterInfoCache;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPool;
import com.launchdarkly.shaded.redis.clients.jedis.exceptions.JedisConnectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JedisClusterConnectionHandler {
    protected final JedisClusterInfoCache cache;

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout) {
        this.cache = new JedisClusterInfoCache(poolConfig, connectionTimeout, soTimeout);
        this.initializeSlotsCache(nodes, poolConfig);
    }

    abstract Jedis getConnection();

    abstract Jedis getConnectionFromSlot(int var1);

    public Jedis getConnectionFromNode(HostAndPort node) {
        this.cache.setNodeIfNotExist(node);
        return this.cache.getNode(JedisClusterInfoCache.getNodeKey(node)).getResource();
    }

    public Map<String, JedisPool> getNodes() {
        return this.cache.getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSlotsCache(Set<HostAndPort> startNodes, GenericObjectPoolConfig poolConfig) {
        for (HostAndPort hostAndPort : startNodes) {
            Jedis jedis = new Jedis(hostAndPort.getHost(), hostAndPort.getPort());
            try {
                this.cache.discoverClusterNodesAndSlots(jedis);
                break;
            }
            catch (JedisConnectionException jedisConnectionException) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        for (HostAndPort node : startNodes) {
            this.cache.setNodeIfNotExist(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewSlotCache() {
        for (JedisPool jp : this.getShuffledNodesPool()) {
            Jedis jedis = null;
            try {
                jedis = jp.getResource();
                this.cache.discoverClusterSlots(jedis);
                break;
            }
            catch (JedisConnectionException jedisConnectionException) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
    }

    public void renewSlotCache(Jedis jedis) {
        try {
            this.cache.discoverClusterSlots(jedis);
        }
        catch (JedisConnectionException e) {
            this.renewSlotCache();
        }
    }

    protected List<JedisPool> getShuffledNodesPool() {
        ArrayList<JedisPool> pools = new ArrayList<JedisPool>();
        pools.addAll(this.cache.getNodes().values());
        Collections.shuffle(pools);
        return pools;
    }
}

