/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Event;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.okhttp3.MediaType;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.RequestBody;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventProcessor
implements Closeable {
    private final ScheduledExecutorService scheduler;
    private final Random random = new Random();
    private final BlockingQueue<Event> queue;
    private final String sdkKey;
    private final LDConfig config;
    private final Consumer consumer;

    EventProcessor(String sdkKey, LDConfig config) {
        this.sdkKey = sdkKey;
        this.queue = new ArrayBlockingQueue<Event>(config.capacity);
        this.consumer = new Consumer(config);
        this.config = config;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-EventProcessor-%d").build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduler.scheduleAtFixedRate(this.consumer, 0L, config.flushInterval, TimeUnit.SECONDS);
    }

    boolean sendEvent(Event e) {
        if (this.config.samplingInterval > 0 && this.random.nextInt(this.config.samplingInterval) != 0) {
            return true;
        }
        return this.queue.offer(e);
    }

    @Override
    public void close() throws IOException {
        this.scheduler.shutdown();
        this.flush();
    }

    public void flush() {
        this.consumer.flush();
    }

    class Consumer
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(Consumer.class);
        private final LDConfig config;

        Consumer(LDConfig config) {
            this.config = config;
        }

        @Override
        public void run() {
            this.flush();
        }

        public void flush() {
            ArrayList<Event> events = new ArrayList<Event>(EventProcessor.this.queue.size());
            EventProcessor.this.queue.drainTo(events);
            if (!events.isEmpty()) {
                this.postEvents(events);
            }
        }

        private void postEvents(List<Event> events) {
            String json = LDConfig.gson.toJson(events);
            this.logger.debug("Posting " + events.size() + " event(s) to " + this.config.eventsURI + " with payload: " + json);
            String content = LDConfig.gson.toJson(events);
            Request request = this.config.getRequestBuilder(EventProcessor.this.sdkKey).url(this.config.eventsURI.toString() + "/bulk").post(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), content)).addHeader("Content-Type", "application/json").build();
            this.logger.debug("Posting " + events.size() + " event(s) using request: " + request);
            try (Response response = this.config.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    this.logger.info("Got unexpected response when posting events: " + response);
                } else {
                    this.logger.debug("Events Response: " + response.code());
                }
            }
            catch (IOException e) {
                this.logger.info("Unhandled exception in LaunchDarkly client when posting events to URL: " + request.url(), (Throwable)e);
            }
        }
    }
}

