/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.AsyncEventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventParser;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ModernTLSSocketFactory;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ReadyState;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.UnsuccessfulResponseException;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.Call;
import com.launchdarkly.shaded.okhttp3.ConnectionPool;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import com.launchdarkly.shaded.okio.BufferedSource;
import com.launchdarkly.shaded.okio.Okio;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSource
implements ConnectionHandler,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(EventSource.class);
    private static final long DEFAULT_RECONNECT_TIME_MS = 1000L;
    static final long MAX_RECONNECT_TIME_MS = 30000L;
    private volatile URI uri;
    private final Headers headers;
    private final ExecutorService executor;
    private volatile long reconnectTimeMs = 0L;
    private volatile String lastEventId;
    private final EventHandler handler;
    private final AtomicReference<ReadyState> readyState;
    private final OkHttpClient client;
    private volatile Call call;
    private final Random jitter = new Random();
    private BufferedSource bufferedSource = null;

    EventSource(Builder builder) {
        this.uri = builder.uri;
        this.headers = EventSource.addDefaultHeaders(builder.headers);
        this.reconnectTimeMs = builder.reconnectTimeMs;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("okhttp-eventsource-%d").build();
        this.executor = Executors.newSingleThreadExecutor(threadFactory);
        this.handler = new AsyncEventHandler(this.executor, builder.handler);
        this.readyState = new AtomicReference<ReadyState>(ReadyState.RAW);
        OkHttpClient.Builder clientBuilder = builder.client.newBuilder().connectionPool(new ConnectionPool(1, 1L, TimeUnit.SECONDS)).readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).connectTimeout(0L, TimeUnit.SECONDS).retryOnConnectionFailure(true).proxy(builder.proxy);
        try {
            clientBuilder.sslSocketFactory(new ModernTLSSocketFactory(), this.defaultTrustManager());
        }
        catch (GeneralSecurityException e) {
            // empty catch block
        }
        if (builder.proxyAuthenticator != null) {
            clientBuilder.proxyAuthenticator(builder.proxyAuthenticator);
        }
        this.client = clientBuilder.build();
    }

    public void start() {
        if (!this.readyState.compareAndSet(ReadyState.RAW, ReadyState.CONNECTING)) {
            logger.info("Start method called on this already-started EventSource object. Doing nothing");
            return;
        }
        logger.debug("readyState change: " + (Object)((Object)ReadyState.RAW) + " -> " + (Object)((Object)ReadyState.CONNECTING));
        logger.info("Starting EventSource client using URI: " + this.uri);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventSource.this.connect();
            }
        });
    }

    public ReadyState getState() {
        return this.readyState.get();
    }

    @Override
    public void close() throws IOException {
        ReadyState currentState = this.readyState.getAndSet(ReadyState.SHUTDOWN);
        logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.SHUTDOWN));
        if (currentState == ReadyState.SHUTDOWN) {
            return;
        }
        if (currentState == ReadyState.OPEN) {
            try {
                this.handler.onClosed();
            }
            catch (Exception e) {
                this.handler.onError(e);
            }
        }
        this.executor.shutdownNow();
        if (this.bufferedSource != null) {
            this.bufferedSource.close();
        }
        if (this.client != null) {
            if (this.client.connectionPool() != null) {
                this.client.connectionPool().evictAll();
            }
            if (this.client.dispatcher() != null) {
                this.client.dispatcher().cancelAll();
                if (this.client.dispatcher().executorService() != null) {
                    this.client.dispatcher().executorService().shutdownNow();
                }
            }
        }
    }

    private X509TrustManager defaultTrustManager() throws GeneralSecurityException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        return (X509TrustManager)trustManagers[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void connect() {
        Response response = null;
        int reconnectAttempts = 0;
        block19: while (true) {
            try {
                while (!Thread.currentThread().isInterrupted() && this.readyState.get() != ReadyState.SHUTDOWN) {
                    this.maybeWaitWithBackoff(reconnectAttempts++);
                    ReadyState currentState = this.readyState.getAndSet(ReadyState.CONNECTING);
                    logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.CONNECTING));
                    Request.Builder builder = new Request.Builder().headers(this.headers).url(this.uri.toASCIIString()).get();
                    if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                        builder.addHeader("Last-Event-ID", this.lastEventId);
                    }
                    this.call = this.client.newCall(builder.build());
                    response = this.call.execute();
                    if (response.isSuccessful()) {
                        String line;
                        reconnectAttempts = 0;
                        currentState = this.readyState.getAndSet(ReadyState.OPEN);
                        if (currentState != ReadyState.CONNECTING) {
                            logger.warn("Unexpected readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        } else {
                            logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        }
                        logger.info("Connected to Event Source stream.");
                        try {
                            this.handler.onOpen();
                        }
                        catch (Exception e) {
                            this.handler.onError(e);
                        }
                        if (this.bufferedSource != null) {
                            this.bufferedSource.close();
                        }
                        this.bufferedSource = Okio.buffer(response.body().source());
                        EventParser parser = new EventParser(this.uri, this.handler, this);
                        while (!Thread.currentThread().isInterrupted() && (line = this.bufferedSource.readUtf8LineStrict()) != null) {
                            parser.line(line);
                        }
                    } else {
                        logger.debug("Unsuccessful Response: " + response);
                        this.handler.onError(new UnsuccessfulResponseException(response.code()));
                    }
                    currentState = this.readyState.getAndSet(ReadyState.CLOSED);
                    logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.CLOSED));
                    if (response != null && response.body() != null) {
                        response.body().close();
                    }
                    if (this.call != null) {
                        this.call.cancel();
                    }
                    if (currentState != ReadyState.OPEN) continue;
                    try {
                        this.handler.onClosed();
                        continue block19;
                    }
                    catch (Exception e) {
                        this.handler.onError(e);
                        continue;
                    }
                    catch (EOFException eofe) {
                        logger.warn("Connection unexpectedly closed.");
                        continue block19;
                    }
                    catch (IOException ioe) {
                        logger.debug("Connection problem.", (Throwable)ioe);
                        this.handler.onError(ioe);
                        continue block19;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        currentState = this.readyState.getAndSet(ReadyState.CLOSED);
                        logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.CLOSED));
                        if (response != null && response.body() != null) {
                            response.body().close();
                        }
                        if (this.call != null) {
                            this.call.cancel();
                        }
                        if (currentState != ReadyState.OPEN) continue;
                        try {
                            this.handler.onClosed();
                            continue block19;
                        }
                        catch (Exception e) {
                            this.handler.onError(e);
                        }
                    }
                }
                break;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
                break;
            }
        }
    }

    private void maybeWaitWithBackoff(int reconnectAttempts) {
        if (this.reconnectTimeMs > 0L && reconnectAttempts > 0) {
            try {
                long sleepTimeMs = this.backoffWithJitter(reconnectAttempts);
                logger.info("Waiting " + sleepTimeMs + " milliseconds before reconnecting...");
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
    }

    long backoffWithJitter(int reconnectAttempts) {
        long jitterVal = Math.min(30000L, this.reconnectTimeMs * (long)this.pow2(reconnectAttempts));
        return jitterVal / 2L + this.nextLong(this.jitter, jitterVal) / 2L;
    }

    private int pow2(int k) {
        return k < 31 ? 1 << k : Integer.MAX_VALUE;
    }

    private long nextLong(Random rand, long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long r = rand.nextLong() & Long.MAX_VALUE;
        long m = bound - 1L;
        if ((bound & m) == 0L) {
            r = bound * r >> 63;
        } else {
            long u = r;
            while (u - (r = u % bound) + m < 0L) {
                u = rand.nextLong() & Long.MAX_VALUE;
            }
        }
        return r;
    }

    private static Headers addDefaultHeaders(Headers custom) {
        Headers.Builder builder = new Headers.Builder();
        builder.add("Accept", "text/event-stream").add("Cache-Control", "no-cache");
        for (Map.Entry<String, List<String>> header : custom.toMultimap().entrySet()) {
            for (String value : header.getValue()) {
                builder.add(header.getKey(), value);
            }
        }
        return builder.build();
    }

    @Override
    public void setReconnectionTimeMs(long reconnectionTimeMs) {
        this.reconnectTimeMs = reconnectionTimeMs;
    }

    @Override
    public void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public static final class Builder {
        private long reconnectTimeMs = 1000L;
        private final URI uri;
        private final EventHandler handler;
        private Headers headers = Headers.of(new String[0]);
        private Proxy proxy;
        private Authenticator proxyAuthenticator = null;
        private OkHttpClient client = new OkHttpClient();

        public Builder(EventHandler handler, URI uri) {
            this.uri = uri;
            this.handler = handler;
        }

        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMs = reconnectTimeMs;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public EventSource build() {
            return new EventSource(this);
        }
    }
}

