/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.launchdarkly.client.LDCountryCode;
import com.launchdarkly.client.UserAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDUser {
    private final JsonPrimitive key;
    private JsonPrimitive secondary;
    private JsonPrimitive ip;
    private JsonPrimitive email;
    private JsonPrimitive name;
    private JsonPrimitive avatar;
    private JsonPrimitive firstName;
    private JsonPrimitive lastName;
    private JsonPrimitive anonymous;
    private JsonPrimitive country;
    private Map<String, JsonElement> custom;
    private static final Logger logger = LoggerFactory.getLogger(LDUser.class);

    protected LDUser(Builder builder) {
        if (builder.key == null || builder.key.equals("")) {
            logger.warn("User was created with null/empty key");
        }
        this.key = builder.key == null ? null : new JsonPrimitive(builder.key);
        this.ip = builder.ip == null ? null : new JsonPrimitive(builder.ip);
        this.country = builder.country == null ? null : new JsonPrimitive(builder.country.getAlpha2());
        this.secondary = builder.secondary == null ? null : new JsonPrimitive(builder.secondary);
        this.firstName = builder.firstName == null ? null : new JsonPrimitive(builder.firstName);
        this.lastName = builder.lastName == null ? null : new JsonPrimitive(builder.lastName);
        this.email = builder.email == null ? null : new JsonPrimitive(builder.email);
        this.name = builder.name == null ? null : new JsonPrimitive(builder.name);
        this.avatar = builder.avatar == null ? null : new JsonPrimitive(builder.avatar);
        this.anonymous = builder.anonymous == null ? null : new JsonPrimitive(builder.anonymous);
        this.custom = new HashMap<String, JsonElement>(builder.custom);
    }

    public LDUser(String key) {
        this.key = new JsonPrimitive(key);
        this.custom = new HashMap<String, JsonElement>();
    }

    protected JsonElement getValueForEvaluation(String attribute) {
        try {
            return UserAttribute.valueOf(attribute).get(this);
        }
        catch (IllegalArgumentException expected) {
            return this.getCustom(attribute);
        }
    }

    JsonPrimitive getKey() {
        return this.key;
    }

    String getKeyAsString() {
        if (this.key == null) {
            return "";
        }
        return this.key.getAsString();
    }

    JsonPrimitive getIp() {
        return this.ip;
    }

    JsonPrimitive getCountry() {
        return this.country;
    }

    JsonPrimitive getSecondary() {
        return this.secondary;
    }

    JsonPrimitive getName() {
        return this.name;
    }

    JsonPrimitive getFirstName() {
        return this.firstName;
    }

    JsonPrimitive getLastName() {
        return this.lastName;
    }

    JsonPrimitive getEmail() {
        return this.email;
    }

    JsonPrimitive getAvatar() {
        return this.avatar;
    }

    JsonPrimitive getAnonymous() {
        return this.anonymous;
    }

    JsonElement getCustom(String key) {
        if (this.custom != null) {
            return this.custom.get(key);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LDUser ldUser = (LDUser)o;
        if (this.key != null ? !this.key.equals(ldUser.key) : ldUser.key != null) {
            return false;
        }
        if (this.secondary != null ? !this.secondary.equals(ldUser.secondary) : ldUser.secondary != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(ldUser.ip) : ldUser.ip != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(ldUser.email) : ldUser.email != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(ldUser.name) : ldUser.name != null) {
            return false;
        }
        if (this.avatar != null ? !this.avatar.equals(ldUser.avatar) : ldUser.avatar != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(ldUser.firstName) : ldUser.firstName != null) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(ldUser.lastName) : ldUser.lastName != null) {
            return false;
        }
        if (this.anonymous != null ? !this.anonymous.equals(ldUser.anonymous) : ldUser.anonymous != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(ldUser.country) : ldUser.country != null) {
            return false;
        }
        return this.custom != null ? this.custom.equals(ldUser.custom) : ldUser.custom == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.secondary != null ? this.secondary.hashCode() : 0);
        result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.avatar != null ? this.avatar.hashCode() : 0);
        result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
        result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        result = 31 * result + (this.anonymous != null ? this.anonymous.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String key;
        private String secondary;
        private String ip;
        private String firstName;
        private String lastName;
        private String email;
        private String name;
        private String avatar;
        private Boolean anonymous;
        private LDCountryCode country;
        private Map<String, JsonElement> custom;

        public Builder(String key) {
            this.key = key;
            this.custom = new HashMap<String, JsonElement>();
        }

        public Builder ip(String s) {
            this.ip = s;
            return this;
        }

        public Builder secondary(String s) {
            this.secondary = s;
            return this;
        }

        public Builder country(String s) {
            this.country = LDCountryCode.getByCode(s, false);
            if (this.country == null) {
                List<LDCountryCode> codes = LDCountryCode.findByName("^" + Pattern.quote(s) + ".*");
                if (codes.isEmpty()) {
                    logger.warn("Invalid country. Expected valid ISO-3166-1 code: " + s);
                } else if (codes.size() > 1) {
                    for (LDCountryCode c : codes) {
                        if (!c.getName().equals(s)) continue;
                        this.country = c;
                        return this;
                    }
                    logger.warn("Ambiguous country. Provided code matches multiple countries: " + s);
                    this.country = codes.get(0);
                } else {
                    this.country = codes.get(0);
                }
            }
            return this;
        }

        public Builder country(LDCountryCode country) {
            this.country = country;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder custom(String k, String v) {
            this.checkCustomAttribute(k);
            if (k != null && v != null) {
                this.custom.put(k, new JsonPrimitive(v));
            }
            return this;
        }

        public Builder custom(String k, Number n) {
            this.checkCustomAttribute(k);
            if (k != null && n != null) {
                this.custom.put(k, new JsonPrimitive(n));
            }
            return this;
        }

        public Builder custom(String k, Boolean b) {
            this.checkCustomAttribute(k);
            if (k != null && b != null) {
                this.custom.put(k, new JsonPrimitive(b));
            }
            return this;
        }

        public Builder custom(String k, List<String> vs) {
            this.checkCustomAttribute(k);
            return this.customString(k, vs);
        }

        public Builder customString(String k, List<String> vs) {
            this.checkCustomAttribute(k);
            JsonArray array = new JsonArray();
            for (String v : vs) {
                if (v == null) continue;
                array.add(new JsonPrimitive(v));
            }
            this.custom.put(k, array);
            return this;
        }

        public Builder customNumber(String k, List<Number> vs) {
            this.checkCustomAttribute(k);
            JsonArray array = new JsonArray();
            for (Number v : vs) {
                if (v == null) continue;
                array.add(new JsonPrimitive(v));
            }
            this.custom.put(k, array);
            return this;
        }

        private void checkCustomAttribute(String key) {
            for (UserAttribute a : UserAttribute.values()) {
                if (!a.name().equals(key)) continue;
                logger.warn("Built-in attribute key: " + key + " added as custom attribute! This custom attribute will be ignored during Feature Flag evaluation");
                return;
            }
        }

        public LDUser build() {
            return new LDUser(this);
        }
    }
}

