/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.EvaluationException;
import com.launchdarkly.client.FeatureRequestEvent;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.Prerequisite;
import com.launchdarkly.client.Rule;
import com.launchdarkly.client.Target;
import com.launchdarkly.client.VariationOrRollout;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeatureFlag {
    private static final Logger logger = LoggerFactory.getLogger(FeatureFlag.class);
    private static final Type mapType = new TypeToken<Map<String, FeatureFlag>>(){}.getType();
    private String key;
    private int version;
    private boolean on;
    private List<Prerequisite> prerequisites;
    private String salt;
    private List<Target> targets;
    private List<Rule> rules;
    private VariationOrRollout fallthrough;
    private Integer offVariation;
    private List<JsonElement> variations;
    private boolean deleted;

    static FeatureFlag fromJson(String json) {
        return LDConfig.gson.fromJson(json, FeatureFlag.class);
    }

    static Map<String, FeatureFlag> fromJsonMap(String json) {
        return (Map)LDConfig.gson.fromJson(json, mapType);
    }

    FeatureFlag() {
    }

    FeatureFlag(String key, int version, boolean on, List<Prerequisite> prerequisites, String salt, List<Target> targets, List<Rule> rules, VariationOrRollout fallthrough, Integer offVariation, List<JsonElement> variations, boolean deleted) {
        this.key = key;
        this.version = version;
        this.on = on;
        this.prerequisites = prerequisites;
        this.salt = salt;
        this.targets = targets;
        this.rules = rules;
        this.fallthrough = fallthrough;
        this.offVariation = offVariation;
        this.variations = variations;
        this.deleted = deleted;
    }

    EvalResult evaluate(LDUser user, FeatureStore featureStore) throws EvaluationException {
        JsonElement value;
        ArrayList<FeatureRequestEvent> prereqEvents = new ArrayList<FeatureRequestEvent>();
        if (user == null || user.getKey() == null) {
            logger.warn("Null user or null user key when evaluating flag: " + this.key + "; returning null");
            return new EvalResult(null, prereqEvents);
        }
        if (this.isOn() && (value = this.evaluate(user, featureStore, prereqEvents)) != null) {
            return new EvalResult(value, prereqEvents);
        }
        JsonElement offVariation = this.getOffVariationValue();
        return new EvalResult(offVariation, prereqEvents);
    }

    private JsonElement evaluate(LDUser user, FeatureStore featureStore, List<FeatureRequestEvent> events) throws EvaluationException {
        boolean prereqOk = true;
        if (this.prerequisites != null) {
            for (Prerequisite prereq : this.prerequisites) {
                FeatureFlag prereqFeatureFlag = featureStore.get(prereq.getKey());
                JsonElement prereqEvalResult = null;
                if (prereqFeatureFlag == null) {
                    logger.error("Could not retrieve prerequisite flag: " + prereq.getKey() + " when evaluating: " + this.key);
                    return null;
                }
                if (prereqFeatureFlag.isOn()) {
                    prereqEvalResult = prereqFeatureFlag.evaluate(user, featureStore, events);
                    try {
                        JsonElement variation = prereqFeatureFlag.getVariation(prereq.getVariation());
                        if (prereqEvalResult == null || variation == null || !prereqEvalResult.equals(variation)) {
                            prereqOk = false;
                        }
                    }
                    catch (EvaluationException err) {
                        logger.warn("Error evaluating prerequisites: " + err.getMessage());
                        prereqOk = false;
                    }
                } else {
                    prereqOk = false;
                }
                events.add(new FeatureRequestEvent(prereqFeatureFlag.getKey(), user, prereqEvalResult, null, prereqFeatureFlag.getVersion(), this.key));
            }
        }
        if (prereqOk) {
            return this.getVariation(this.evaluateIndex(user));
        }
        return null;
    }

    private Integer evaluateIndex(LDUser user) {
        if (this.targets != null) {
            for (Target target : this.targets) {
                for (String v : target.getValues()) {
                    if (!v.equals(user.getKey().getAsString())) continue;
                    return target.getVariation();
                }
            }
        }
        if (this.rules != null) {
            for (Rule rule : this.rules) {
                if (!rule.matchesUser(user)) continue;
                return rule.variationIndexForUser(user, this.key, this.salt);
            }
        }
        return this.fallthrough.variationIndexForUser(user, this.key, this.salt);
    }

    JsonElement getOffVariationValue() throws EvaluationException {
        if (this.offVariation == null) {
            return null;
        }
        if (this.offVariation >= this.variations.size()) {
            throw new EvaluationException("Invalid off variation index");
        }
        return this.variations.get(this.offVariation);
    }

    private JsonElement getVariation(Integer index) throws EvaluationException {
        if (index == null) {
            return null;
        }
        if (index >= this.variations.size()) {
            throw new EvaluationException("Invalid index");
        }
        return this.variations.get(index);
    }

    int getVersion() {
        return this.version;
    }

    String getKey() {
        return this.key;
    }

    boolean isDeleted() {
        return this.deleted;
    }

    boolean isOn() {
        return this.on;
    }

    List<Prerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    String getSalt() {
        return this.salt;
    }

    List<Target> getTargets() {
        return this.targets;
    }

    List<Rule> getRules() {
        return this.rules;
    }

    VariationOrRollout getFallthrough() {
        return this.fallthrough;
    }

    List<JsonElement> getVariations() {
        return this.variations;
    }

    Integer getOffVariation() {
        return this.offVariation;
    }

    static class EvalResult {
        private final JsonElement value;
        private final List<FeatureRequestEvent> prerequisiteEvents;

        private EvalResult(JsonElement value, List<FeatureRequestEvent> prerequisiteEvents) {
            this.value = value;
            this.prerequisiteEvents = prerequisiteEvents;
        }

        JsonElement getValue() {
            return this.value;
        }

        List<FeatureRequestEvent> getPrerequisiteEvents() {
            return this.prerequisiteEvents;
        }
    }
}

