/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeatureRequestor {
    private static final Logger logger = LoggerFactory.getLogger(FeatureRequestor.class);
    private static final String GET_LATEST_FLAGS_PATH = "/sdk/latest-flags";
    private final String sdkKey;
    private final LDConfig config;

    FeatureRequestor(String sdkKey, LDConfig config) {
        this.sdkKey = sdkKey;
        this.config = config;
    }

    Map<String, FeatureFlag> getAllFlags() throws IOException {
        String body = this.get(GET_LATEST_FLAGS_PATH);
        return FeatureFlag.fromJsonMap(body);
    }

    FeatureFlag getFlag(String featureKey) throws IOException {
        String body = this.get("/sdk/latest-flags/" + featureKey);
        return FeatureFlag.fromJson(body);
    }

    private String get(String path) throws IOException {
        Request request = this.config.getRequestBuilder(this.sdkKey).url(this.config.baseURI.toString() + path).get().build();
        logger.debug("Making request: " + request);
        try (Response response = this.config.httpClient.newCall(request).execute();){
            String body = response.body().string();
            if (!response.isSuccessful()) {
                if (response.code() == 401) {
                    logger.error("[401] Invalid SDK key when accessing URI: " + request.url());
                }
                throw new IOException("Unexpected response when retrieving Feature Flag(s): " + response + " using url: " + request.url() + " with body: " + body);
            }
            logger.debug("Get flag(s) response: " + response.toString() + " with body: " + body);
            logger.debug("Cache hit count: " + this.config.httpClient.cache().hitCount() + " Cache network Count: " + this.config.httpClient.cache().networkCount());
            logger.debug("Cache response: " + response.cacheResponse());
            logger.debug("Network response: " + response.networkResponse());
            String string = body;
            return string;
        }
    }
}

